/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.firebird.visitor.statement.type;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DMLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.FirebirdStatementParser;
import org.apache.shardingsphere.sql.parser.engine.firebird.visitor.statement.FirebirdStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.JoinType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.ParameterMarkerLimitValueSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.FunctionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.MergeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.parametermarker.ParameterMarkerValue;

public final class FirebirdDMLStatementVisitor
extends FirebirdStatementVisitor
implements DMLStatementVisitor {
    public FirebirdDMLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitInsert(FirebirdStatementParser.InsertContext ctx) {
        InsertStatement result = (InsertStatement)this.visit((ParseTree)ctx.insertValuesClause());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.addParameterMarkers(this.getParameterMarkerSegments());
        if (null != ctx.returningClause()) {
            result.setReturning((ReturningSegment)this.visit((ParseTree)ctx.returningClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitInsertValuesClause(FirebirdStatementParser.InsertValuesClauseContext ctx) {
        InsertStatement result = new InsertStatement(this.getDatabaseType());
        if (null != ctx.columnNames()) {
            FirebirdStatementParser.ColumnNamesContext columnNames = ctx.columnNames();
            CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)columnNames);
            result.setInsertColumns(new InsertColumnsSegment(columnNames.start.getStartIndex(), columnNames.stop.getStopIndex(), columnSegments.getValue()));
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(Collection<FirebirdStatementParser.AssignmentValuesContext> assignmentValuesContexts) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (FirebirdStatementParser.AssignmentValuesContext each : assignmentValuesContexts) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitReturningClause(FirebirdStatementParser.ReturningClauseContext ctx) {
        return new ReturningSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ProjectionsSegment)this.visit((ParseTree)ctx.projections()));
    }

    @Override
    public ASTNode visitUpdate(FirebirdStatementParser.UpdateContext ctx) {
        UpdateStatement result = new UpdateStatement(this.getDatabaseType());
        result.setTable((TableSegment)this.visit((ParseTree)ctx.tableReferences()));
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        if (null != ctx.returningClause()) {
            result.setReturning((ReturningSegment)this.visit((ParseTree)ctx.returningClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitSetAssignmentsClause(FirebirdStatementParser.SetAssignmentsClauseContext ctx) {
        LinkedList<ColumnAssignmentSegment> assignments = new LinkedList<ColumnAssignmentSegment>();
        for (FirebirdStatementParser.AssignmentContext each : ctx.assignment()) {
            assignments.add((ColumnAssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitAssignmentValues(FirebirdStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (FirebirdStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignment(FirebirdStatementParser.AssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.assignmentValue());
        return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
    }

    @Override
    public ASTNode visitAssignmentValue(FirebirdStatementParser.AssignmentValueContext ctx) {
        FirebirdStatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitDelete(FirebirdStatementParser.DeleteContext ctx) {
        DeleteStatement result = new DeleteStatement(this.getDatabaseType());
        result.setTable((TableSegment)this.visit((ParseTree)ctx.singleTableClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.addParameterMarkers(this.getParameterMarkerSegments());
        if (null != ctx.returningClause()) {
            result.setReturning((ReturningSegment)this.visit((ParseTree)ctx.returningClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitSingleTableClause(FirebirdStatementParser.SingleTableClauseContext ctx) {
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitSelect(FirebirdStatementParser.SelectContext ctx) {
        SelectStatement result = (SelectStatement)this.visit((ParseTree)ctx.combineClause());
        result.addParameterMarkers(this.getParameterMarkerSegments());
        if (null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitCombineClause(FirebirdStatementParser.CombineClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectClause(0));
    }

    @Override
    public ASTNode visitSelectClause(FirebirdStatementParser.SelectClauseContext ctx) {
        SelectStatement result = new SelectStatement(this.getDatabaseType());
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.projections()));
        if (null != ctx.firstSkipClause()) {
            result.setLimit((LimitSegment)this.visit((ParseTree)ctx.firstSkipClause()));
        }
        if (!ctx.selectSpecification().isEmpty()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx.selectSpecification().get(0)));
        }
        if (null != ctx.fromClause()) {
            TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.fromClause());
            result.setFrom(tableSegment);
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        if (null != ctx.havingClause()) {
            result.setHaving((HavingSegment)this.visit((ParseTree)ctx.havingClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitFirstSkipClause(FirebirdStatementParser.FirstSkipClauseContext ctx) {
        PaginationValueSegment rowCount = null;
        PaginationValueSegment offset = null;
        if (null != ctx.FIRST()) {
            rowCount = (PaginationValueSegment)this.visit((ParseTree)ctx.firstValue());
            if (null != ctx.SKIP_()) {
                offset = (PaginationValueSegment)this.visit((ParseTree)ctx.skipValue());
            }
        } else if (null != ctx.SKIP_()) {
            offset = (PaginationValueSegment)this.visit((ParseTree)ctx.skipValue());
        }
        return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), offset, rowCount);
    }

    @Override
    public ASTNode visitFirstValue(FirebirdStatementParser.FirstValueContext ctx) {
        if (null != ctx.numberLiterals()) {
            return new NumberLiteralLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.numberLiterals())).getValue().longValue()));
        }
        ParameterMarkerLimitValueSegment result = new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        this.getParameterMarkerSegments().add((ParameterMarkerSegment)result);
        return result;
    }

    @Override
    public ASTNode visitSkipValue(FirebirdStatementParser.SkipValueContext ctx) {
        if (null != ctx.numberLiterals()) {
            return new NumberLiteralLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Long.valueOf(((NumberLiteralValue)this.visit((ParseTree)ctx.numberLiterals())).getValue().longValue()));
        }
        ParameterMarkerLimitValueSegment result = new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        this.getParameterMarkerSegments().add((ParameterMarkerSegment)result);
        return result;
    }

    @Override
    public ASTNode visitHavingClause(FirebirdStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    private boolean isDistinct(FirebirdStatementParser.SelectSpecificationContext ctx) {
        return ((BooleanLiteralValue)this.visit((ParseTree)ctx.duplicateSpecification())).getValue();
    }

    @Override
    public ASTNode visitDuplicateSpecification(FirebirdStatementParser.DuplicateSpecificationContext ctx) {
        return new BooleanLiteralValue(null != ctx.DISTINCT());
    }

    @Override
    public ASTNode visitProjections(FirebirdStatementParser.ProjectionsContext ctx) {
        LinkedList<Object> projections = new LinkedList<Object>();
        if (null != ctx.unqualifiedShorthand()) {
            projections.add(new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex()));
        }
        for (FirebirdStatementParser.ProjectionContext each : ctx.projection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.getProjections().addAll(projections);
        return result;
    }

    @Override
    public ASTNode visitProjection(FirebirdStatementParser.ProjectionContext ctx) {
        AliasSegment alias;
        if (null != ctx.qualifiedShorthand()) {
            FirebirdStatementParser.QualifiedShorthandContext shorthand = ctx.qualifiedShorthand();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(shorthand.getStart().getStartIndex(), shorthand.getStop().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(shorthand.identifier().getText());
            result.setOwner(new OwnerSegment(shorthand.identifier().getStart().getStartIndex(), shorthand.identifier().getStop().getStopIndex(), identifier));
            return result;
        }
        AliasSegment aliasSegment = alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            ColumnProjectionSegment result = new ColumnProjectionSegment(column);
            result.setAlias(alias);
            return result;
        }
        return this.createProjection(ctx, alias);
    }

    @Override
    public ASTNode visitAlias(FirebirdStatementParser.AliasContext ctx) {
        return null == ctx.identifier() ? new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.STRING_().getText())) : new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    private ASTNode createProjection(FirebirdStatementParser.ProjectionContext ctx, AliasSegment alias) {
        ASTNode projection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof FunctionSegment) {
            FunctionSegment segment = (FunctionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx), (ExpressionSegment)((ColumnSegment)projection));
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((SubqueryExpressionSegment)projection).getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BinaryOperationExpression) {
            BinaryOperationExpression binaryExpression = (BinaryOperationExpression)projection;
            int startIndex = binaryExpression.getStartIndex();
            int stopIndex = null == alias ? binaryExpression.getStopIndex() : alias.getStopIndex();
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, binaryExpression.getText(), (ExpressionSegment)binaryExpression);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ParameterMarkerExpressionSegment) {
            ParameterMarkerExpressionSegment result = (ParameterMarkerExpressionSegment)projection;
            result.setAlias(alias);
            return projection;
        }
        ExpressionSegment column = (ExpressionSegment)projection;
        ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(column.getStartIndex(), column.getStopIndex(), String.valueOf(column.getText()), column) : new ExpressionProjectionSegment(column.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(column.getText()), column);
        result.setAlias(alias);
        return result;
    }

    @Override
    public ASTNode visitFromClause(FirebirdStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitTableReferences(FirebirdStatementParser.TableReferencesContext ctx) {
        TableSegment result = (TableSegment)this.visit((ParseTree)ctx.escapedTableReference(0));
        if (ctx.escapedTableReference().size() > 1) {
            for (int i = 1; i < ctx.escapedTableReference().size(); ++i) {
                result = this.generateJoinTableSourceFromEscapedTableReference(ctx.escapedTableReference(i), result);
            }
        }
        return result;
    }

    private JoinTableSegment generateJoinTableSourceFromEscapedTableReference(FirebirdStatementParser.EscapedTableReferenceContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setLeft(tableSegment);
        result.setRight((TableSegment)this.visit((ParseTree)ctx));
        result.setJoinType(JoinType.COMMA.name());
        return result;
    }

    @Override
    public ASTNode visitEscapedTableReference(FirebirdStatementParser.EscapedTableReferenceContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReference());
    }

    @Override
    public ASTNode visitTableReference(FirebirdStatementParser.TableReferenceContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        if (!ctx.joinedTable().isEmpty()) {
            for (FirebirdStatementParser.JoinedTableContext each : ctx.joinedTable()) {
                left = this.visitJoinedTable(each, left);
            }
        }
        TableSegment result = left;
        return result;
    }

    @Override
    public ASTNode visitTableFactor(FirebirdStatementParser.TableFactorContext ctx) {
        if (null != ctx.subquery()) {
            SelectStatement subquery = (SelectStatement)this.visit((ParseTree)ctx.subquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), subquery, this.getOriginalText(ctx.subquery()));
            SubqueryTableSegment result = new SubqueryTableSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), subquerySegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.expr()) {
            ExpressionSegment exprSegment = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            FunctionTableSegment result = new FunctionTableSegment(exprSegment.getStartIndex(), exprSegment.getStopIndex(), exprSegment);
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    private JoinTableSegment visitJoinedTable(FirebirdStatementParser.JoinedTableContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        TableSegment right = (TableSegment)this.visit((ParseTree)ctx.tableFactor());
        result.setRight(right);
        result.setJoinType(this.getJoinType(ctx));
        if (null != ctx.joinSpecification()) {
            this.visitJoinSpecification(ctx.joinSpecification(), result);
        }
        return result;
    }

    private String getJoinType(FirebirdStatementParser.JoinedTableContext ctx) {
        if (null != ctx.LEFT()) {
            return JoinType.LEFT.name();
        }
        if (null != ctx.RIGHT()) {
            return JoinType.RIGHT.name();
        }
        if (null != ctx.INNER()) {
            return JoinType.INNER.name();
        }
        if (null != ctx.CROSS()) {
            return JoinType.CROSS.name();
        }
        return JoinType.INNER.name();
    }

    private void visitJoinSpecification(FirebirdStatementParser.JoinSpecificationContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            joinTableSource.setUsing(ctx.columnNames().columnName().stream().map(each -> (ColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
        }
    }

    @Override
    public ASTNode visitWhereClause(FirebirdStatementParser.WhereClauseContext ctx) {
        ExpressionSegment segment = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segment);
    }

    @Override
    public ASTNode visitGroupByClause(FirebirdStatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (FirebirdStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public ASTNode visitSubquery(FirebirdStatementParser.SubqueryContext ctx) {
        SelectStatement result = (SelectStatement)this.visit((ParseTree)ctx.combineClause());
        if (null != ctx.withClause()) {
            result.setWith((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitMerge(FirebirdStatementParser.MergeContext ctx) {
        MergeStatement result = new MergeStatement(this.getDatabaseType());
        result.setTarget((TableSegment)this.visit((ParseTree)ctx.intoClause()));
        result.setSource((TableSegment)this.visit((ParseTree)ctx.usingClause()));
        return result;
    }
}

