/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.firebird.visitor.statement.type;

import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.FirebirdStatementParser;
import org.apache.shardingsphere.sql.parser.engine.firebird.visitor.statement.FirebirdStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.GrantStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.RevokeStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.CreateUserStatement;

public final class FirebirdDCLStatementVisitor
extends FirebirdStatementVisitor
implements DCLStatementVisitor {
    public FirebirdDCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitGrant(FirebirdStatementParser.GrantContext ctx) {
        GrantStatement result = new GrantStatement(this.getDatabaseType());
        if (null != ctx.privilegeClause()) {
            result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.privilegeClause().onObjectClause().privilegeLevel().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(FirebirdStatementParser.RevokeContext ctx) {
        RevokeStatement result = new RevokeStatement(this.getDatabaseType());
        if (null != ctx.privilegeClause()) {
            result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.privilegeClause().onObjectClause().privilegeLevel().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateRole(FirebirdStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateUser(FirebirdStatementParser.CreateUserContext ctx) {
        return new CreateUserStatement(this.getDatabaseType());
    }
}

