/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.mysql.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereConstraint;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.sharding.merge.mysql.type.MySQLShardingLogicTablesMergedResult;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class MySQLShardingShowCreateTableMergedResult
extends MySQLShardingLogicTablesMergedResult {
    public MySQLShardingShowCreateTableMergedResult(ShardingRule rule, SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super(rule, sqlStatementContext, schema, queryResults);
    }

    @Override
    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, ShardingSphereTable table, ShardingRule rule) {
        this.replaceTables(memoryResultSetRow, logicTableName, actualTableName);
        this.replaceBindingTables(memoryResultSetRow, logicTableName, actualTableName, rule);
        this.replaceIndexes(memoryResultSetRow, actualTableName, table);
        this.replaceConstraints(memoryResultSetRow, actualTableName, table, rule);
    }

    private void replaceTables(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName) {
        memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replaceFirst(actualTableName, logicTableName));
    }

    private void replaceBindingTables(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, ShardingRule rule) {
        Optional shardingTable = rule.findShardingTable(logicTableName);
        Optional bindingTableRule = rule.findBindingTableRule(logicTableName);
        if (!shardingTable.isPresent() || !bindingTableRule.isPresent()) {
            return;
        }
        Collection actualDataNodes = ((ShardingTable)shardingTable.get()).getActualDataNodes().stream().filter(each -> each.getTableName().equalsIgnoreCase(actualTableName)).collect(Collectors.toList());
        CaseInsensitiveMap logicAndActualTablesFromBindingTables = new CaseInsensitiveMap();
        for (DataNode dataNode : actualDataNodes) {
            logicAndActualTablesFromBindingTables.putAll(rule.getLogicAndActualTablesFromBindingTable(dataNode.getDataSourceName(), logicTableName, actualTableName, ((BindingTableRule)bindingTableRule.get()).getAllLogicTables()));
        }
        for (Map.Entry entry : logicAndActualTablesFromBindingTables.entrySet()) {
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replaceFirst((String)entry.getValue(), (String)entry.getKey()));
        }
    }

    private void replaceIndexes(MemoryQueryResultRow memoryResultSetRow, String actualTableName, ShardingSphereTable table) {
        for (ShardingSphereIndex each : table.getAllIndexes()) {
            String actualIndexName = IndexMetaDataUtils.getActualIndexName((String)each.getName(), (String)actualTableName);
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(actualIndexName, each.getName()));
        }
    }

    private void replaceConstraints(MemoryQueryResultRow memoryResultSetRow, String actualTableName, ShardingSphereTable table, ShardingRule rule) {
        for (ShardingSphereConstraint each : table.getAllConstraints()) {
            String actualIndexName = IndexMetaDataUtils.getActualIndexName((String)each.getName(), (String)actualTableName);
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(actualIndexName, each.getName()));
            Optional shardingTable = rule.findShardingTable(each.getReferencedTableName());
            if (!shardingTable.isPresent()) continue;
            for (DataNode dataNode : ((ShardingTable)shardingTable.get()).getActualDataNodes()) {
                memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(dataNode.getTableName(), each.getReferencedTableName()));
            }
        }
    }
}

