/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.mysql;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sharding.merge.dal.DialectShardingDALResultMerger;
import org.apache.shardingsphere.sharding.merge.mysql.type.MySQLShardingLogicTablesMergedResult;
import org.apache.shardingsphere.sharding.merge.mysql.type.MySQLShardingShowCreateTableMergedResult;
import org.apache.shardingsphere.sharding.merge.mysql.type.MySQLShardingShowIndexMergedResult;
import org.apache.shardingsphere.sharding.merge.mysql.type.MySQLShardingShowTableStatusMergedResult;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.database.MySQLShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.index.MySQLShowIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowCreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTableStatusStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.show.table.MySQLShowTablesStatement;

public final class MySQLShardingDALResultMerger
implements DialectShardingDALResultMerger {
    public Optional<MergedResult> merge(String databaseName, ShardingRule rule, SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        SQLStatement dalStatement = sqlStatementContext.getSqlStatement();
        if (dalStatement instanceof MySQLShowDatabasesStatement) {
            return Optional.of(new LocalDataMergedResult(Collections.singleton(new LocalDataQueryResultRow(new Object[]{databaseName}))));
        }
        if (dalStatement instanceof MySQLShowTablesStatement) {
            return Optional.of(new MySQLShardingLogicTablesMergedResult(rule, sqlStatementContext, schema, queryResults));
        }
        if (dalStatement instanceof MySQLShowTableStatusStatement) {
            return Optional.of(new MySQLShardingShowTableStatusMergedResult(rule, sqlStatementContext, schema, queryResults));
        }
        if (dalStatement instanceof MySQLShowIndexStatement) {
            return Optional.of(new MySQLShardingShowIndexMergedResult(rule, sqlStatementContext, schema, queryResults));
        }
        if (dalStatement instanceof MySQLShowCreateTableStatement) {
            return Optional.of(new MySQLShardingShowCreateTableMergedResult(rule, sqlStatementContext, schema, queryResults));
        }
        return Optional.empty();
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

