/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.okio;

import java.io.IOException;
import javax.crypto.Cipher;
import org.apache.shardingsphere.shade.kotlin.Metadata;
import org.apache.shardingsphere.shade.kotlin.jvm.internal.Intrinsics;
import org.apache.shardingsphere.shade.kotlin.jvm.internal.SourceDebugExtension;
import org.apache.shardingsphere.shade.okio.Buffer;
import org.apache.shardingsphere.shade.okio.BufferedSource;
import org.apache.shardingsphere.shade.okio.Segment;
import org.apache.shardingsphere.shade.okio.SegmentPool;
import org.apache.shardingsphere.shade.okio.Source;
import org.apache.shardingsphere.shade.okio.Timeout;
import org.apache.shardingsphere.shade.org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/apache/shardingsphere/shade/okio/CipherSource;", "Lorg/apache/shardingsphere/shade/okio/Source;", "source", "Lorg/apache/shardingsphere/shade/okio/BufferedSource;", "cipher", "Ljavax/crypto/Cipher;", "<init>", "(Lokio/BufferedSource;Ljavax/crypto/Cipher;)V", "getCipher", "()Ljavax/crypto/Cipher;", "blockSize", "", "buffer", "Lorg/apache/shardingsphere/shade/okio/Buffer;", "final", "", "closed", "read", "", "sink", "byteCount", "refill", "", "update", "doFinal", "timeout", "Lorg/apache/shardingsphere/shade/okio/Timeout;", "close", "org.apache.shardingsphere.shade.okio"})
@SourceDebugExtension(value={"SMAP\nCipherSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CipherSource.kt\nokio/CipherSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class CipherSource
implements Source {
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final Cipher cipher;
    private final int blockSize;
    @NotNull
    private final Buffer buffer;
    private boolean final;
    private boolean closed;

    public CipherSource(@NotNull BufferedSource source2, @NotNull Cipher cipher) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(cipher, "cipher");
        this.source = source2;
        this.cipher = cipher;
        this.blockSize = this.cipher.getBlockSize();
        this.buffer = new Buffer();
        if (!(this.blockSize > 0)) {
            boolean bl = false;
            String string = "Block cipher required " + this.cipher;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Cipher getCipher() {
        return this.cipher;
    }

    @Override
    public long read(@NotNull Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        if (!(byteCount >= 0L)) {
            boolean $i$a$-require-CipherSource$read$22 = false;
            String $i$a$-require-CipherSource$read$22 = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException($i$a$-require-CipherSource$read$22.toString());
        }
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        if (byteCount == 0L) {
            return 0L;
        }
        this.refill();
        return this.buffer.read(sink2, byteCount);
    }

    private final void refill() {
        while (this.buffer.size() == 0L && !this.final) {
            if (this.source.exhausted()) {
                this.final = true;
                this.doFinal();
                break;
            }
            this.update();
        }
    }

    private final void update() {
        Segment segment = this.source.getBuffer().head;
        Intrinsics.checkNotNull(segment);
        Segment head = segment;
        int size = head.limit - head.pos;
        int outputSize = this.cipher.getOutputSize(size);
        while (outputSize > 8192) {
            if (size <= this.blockSize) {
                this.final = true;
                byte[] byArray = this.cipher.doFinal(this.source.readByteArray());
                Intrinsics.checkNotNullExpressionValue(byArray, "doFinal(...)");
                this.buffer.write(byArray);
                return;
            }
            outputSize = this.cipher.getOutputSize(size -= this.blockSize);
        }
        Segment s = this.buffer.writableSegment$okio(outputSize);
        int ciphered = this.cipher.update(head.data, head.pos, size, s.data, s.pos);
        this.source.skip(size);
        s.limit += ciphered;
        Buffer buffer = this.buffer;
        buffer.setSize$okio(buffer.size() + (long)ciphered);
        if (s.pos == s.limit) {
            this.buffer.head = s.pop();
            SegmentPool.recycle(s);
        }
    }

    private final void doFinal() {
        int outputSize = this.cipher.getOutputSize(0);
        if (outputSize == 0) {
            return;
        }
        Segment s = this.buffer.writableSegment$okio(outputSize);
        int ciphered = this.cipher.doFinal(s.data, s.pos);
        s.limit += ciphered;
        Buffer buffer = this.buffer;
        buffer.setSize$okio(buffer.size() + (long)ciphered);
        if (s.pos == s.limit) {
            this.buffer.head = s.pop();
            SegmentPool.recycle(s);
        }
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.source.close();
    }
}

