/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.LongCounter;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.Meter;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ComponentId;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.SemConvAttributes;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.LongCallable;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanProcessorInstrumentation;

final class SemConvSpanProcessorInstrumentation
implements SpanProcessorInstrumentation {
    private final Object lock = new Object();
    private final AtomicBoolean builtQueueMetrics = new AtomicBoolean(false);
    private final Supplier<MeterProvider> meterProvider;
    private final Attributes standardAttrs;
    private final Attributes droppedAttrs;
    @Nullable
    private Meter meter;
    @Nullable
    private volatile LongCounter processedSpans;

    SemConvSpanProcessorInstrumentation(ComponentId componentId, Supplier<MeterProvider> meterProvider) {
        this.meterProvider = meterProvider;
        this.standardAttrs = Attributes.of(SemConvAttributes.OTEL_COMPONENT_TYPE, componentId.getTypeName(), SemConvAttributes.OTEL_COMPONENT_NAME, componentId.getComponentName());
        this.droppedAttrs = Attributes.of(SemConvAttributes.OTEL_COMPONENT_TYPE, componentId.getTypeName(), SemConvAttributes.OTEL_COMPONENT_NAME, componentId.getComponentName(), SemConvAttributes.ERROR_TYPE, "queue_full");
    }

    @Override
    public void dropSpans(int count) {
        this.processedSpans().add(count, this.droppedAttrs);
    }

    @Override
    public void finishSpans(int count, @Nullable String error) {
        if (error == null) {
            this.processedSpans().add(count, this.standardAttrs);
            return;
        }
        Attributes attributes = this.standardAttrs.toBuilder().put(SemConvAttributes.ERROR_TYPE, error).build();
        this.processedSpans().add(count, attributes);
    }

    @Override
    public void buildQueueMetricsOnce(long capacity, LongCallable getSize) {
        if (!this.builtQueueMetrics.compareAndSet(false, true)) {
            return;
        }
        this.meter().upDownCounterBuilder("otel.sdk.processor.span.queue.capacity").setUnit("span").setDescription("The maximum number of spans the queue of a given instance of an SDK span processor can hold. ").buildWithCallback(m -> m.record(capacity, this.standardAttrs));
        this.meter().upDownCounterBuilder("otel.sdk.processor.span.queue.size").setUnit("span").setDescription("The number of spans in the queue of a given instance of an SDK span processor.").buildWithCallback(m -> m.record(getSize.get(), this.standardAttrs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongCounter processedSpans() {
        LongCounter processedSpans = this.processedSpans;
        if (processedSpans == null) {
            Object object = this.lock;
            synchronized (object) {
                processedSpans = this.processedSpans;
                if (processedSpans == null) {
                    this.processedSpans = processedSpans = this.meter().counterBuilder("otel.sdk.processor.span.processed").setUnit("span").setDescription("The number of spans for which the processing has finished, either successful or failed.").build();
                }
            }
        }
        return processedSpans;
    }

    private Meter meter() {
        if (this.meter == null) {
            this.meter = this.meterProvider.get().get("org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace");
        }
        return this.meter;
    }
}

