/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace;

import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.Utils;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.SpanLimits;

public final class SpanLimitsBuilder {
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_EVENTS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = 128;
    private int maxNumAttributes = 128;
    private int maxNumEvents = 128;
    private int maxNumLinks = 128;
    private int maxNumAttributesPerEvent = 128;
    private int maxNumAttributesPerLink = 128;
    private int maxAttributeValueLength = Integer.MAX_VALUE;

    SpanLimitsBuilder() {
    }

    public SpanLimitsBuilder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
        Utils.checkArgument(maxNumberOfAttributes >= 0, "maxNumberOfAttributes must be non-negative");
        this.maxNumAttributes = maxNumberOfAttributes;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfEvents(int maxNumberOfEvents) {
        Utils.checkArgument(maxNumberOfEvents >= 0, "maxNumberOfEvents must be non-negative");
        this.maxNumEvents = maxNumberOfEvents;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfLinks(int maxNumberOfLinks) {
        Utils.checkArgument(maxNumberOfLinks >= 0, "maxNumberOfLinks must be non-negative");
        this.maxNumLinks = maxNumberOfLinks;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfAttributesPerEvent(int maxNumberOfAttributesPerEvent) {
        Utils.checkArgument(maxNumberOfAttributesPerEvent >= 0, "maxNumberOfAttributesPerEvent must be non-negative");
        this.maxNumAttributesPerEvent = maxNumberOfAttributesPerEvent;
        return this;
    }

    public SpanLimitsBuilder setMaxNumberOfAttributesPerLink(int maxNumberOfAttributesPerLink) {
        Utils.checkArgument(maxNumberOfAttributesPerLink >= 0, "maxNumberOfAttributesPerLink must be non-negative");
        this.maxNumAttributesPerLink = maxNumberOfAttributesPerLink;
        return this;
    }

    public SpanLimitsBuilder setMaxAttributeValueLength(int maxAttributeValueLength) {
        Utils.checkArgument(maxAttributeValueLength >= 0, "maxAttributeValueLength must be non-negative");
        this.maxAttributeValueLength = maxAttributeValueLength;
        return this;
    }

    public SpanLimits build() {
        return SpanLimits.create(this.maxNumAttributes, this.maxNumEvents, this.maxNumLinks, this.maxNumAttributesPerEvent, this.maxNumAttributesPerLink, this.maxAttributeValueLength);
    }
}

