/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.List;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilterInternal;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.LongExemplarReservoir;

class LongFilteredExemplarReservoir
implements LongExemplarReservoir {
    private final ExemplarFilterInternal filter;
    private final LongExemplarReservoir reservoir;

    LongFilteredExemplarReservoir(ExemplarFilterInternal filter, LongExemplarReservoir reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerLongMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<LongExemplarData> collectAndResetLongs(Attributes pointAttributes) {
        return this.reservoir.collectAndResetLongs(pointAttributes);
    }
}

