/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.Clock;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.DoubleExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.LongExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;

class FixedSizeExemplarReservoir
implements DoubleExemplarReservoir,
LongExemplarReservoir {
    @Nullable
    private ReservoirCell[] storage = null;
    private final ReservoirCellSelector reservoirCellSelector;
    private final int size;
    private final Clock clock;
    private volatile boolean hasMeasurements = false;

    FixedSizeExemplarReservoir(Clock clock, int size, ReservoirCellSelector reservoirCellSelector) {
        this.size = size;
        this.clock = clock;
        this.reservoirCellSelector = reservoirCellSelector;
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        int bucket;
        if (this.storage == null) {
            this.storage = this.initStorage();
        }
        if ((bucket = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, value, attributes, context)) != -1) {
            this.storage[bucket].recordLongMeasurement(value, attributes, context);
            this.hasMeasurements = true;
        }
    }

    @Override
    public List<DoubleExemplarData> collectAndResetDoubles(Attributes pointAttributes) {
        return this.doCollectAndReset(pointAttributes, ReservoirCell::getAndResetDouble);
    }

    @Override
    public List<LongExemplarData> collectAndResetLongs(Attributes pointAttributes) {
        return this.doCollectAndReset(pointAttributes, ReservoirCell::getAndResetLong);
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        int bucket;
        if (this.storage == null) {
            this.storage = this.initStorage();
        }
        if ((bucket = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, value, attributes, context)) != -1) {
            this.storage[bucket].recordDoubleMeasurement(value, attributes, context);
            this.hasMeasurements = true;
        }
    }

    private ReservoirCell[] initStorage() {
        ReservoirCell[] storage = new ReservoirCell[this.size];
        for (int i = 0; i < this.size; ++i) {
            storage[i] = new ReservoirCell(this.clock);
        }
        return storage;
    }

    public <T extends ExemplarData> List<T> doCollectAndReset(Attributes pointAttributes, BiFunction<ReservoirCell, Attributes, T> mapAndResetCell) {
        if (!this.hasMeasurements || this.storage == null) {
            return Collections.emptyList();
        }
        ArrayList<ExemplarData> results = new ArrayList<ExemplarData>();
        for (ReservoirCell reservoirCell : this.storage) {
            ExemplarData result = (ExemplarData)mapAndResetCell.apply(reservoirCell, pointAttributes);
            if (result == null) continue;
            results.add(result);
        }
        this.reservoirCellSelector.reset();
        this.hasMeasurements = false;
        return Collections.unmodifiableList(results);
    }
}

