/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.Clock;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.DoubleExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.DoubleFilteredExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilterInternal;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.HistogramExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.LongExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.LongFilteredExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.NoopExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.RandomFixedSizeExemplarReservoir;

public interface ExemplarReservoirFactory {
    public static ExemplarReservoirFactory filtered(final ExemplarFilterInternal filter, final ExemplarReservoirFactory original) {
        return new ExemplarReservoirFactory(){

            @Override
            public DoubleExemplarReservoir createDoubleExemplarReservoir() {
                return new DoubleFilteredExemplarReservoir(filter, original.createDoubleExemplarReservoir());
            }

            @Override
            public LongExemplarReservoir createLongExemplarReservoir() {
                return new LongFilteredExemplarReservoir(filter, original.createLongExemplarReservoir());
            }
        };
    }

    public static ExemplarReservoirFactory noSamples() {
        return new ExemplarReservoirFactory(){

            @Override
            public DoubleExemplarReservoir createDoubleExemplarReservoir() {
                return NoopExemplarReservoir.INSTANCE;
            }

            @Override
            public LongExemplarReservoir createLongExemplarReservoir() {
                return NoopExemplarReservoir.INSTANCE;
            }
        };
    }

    public static ExemplarReservoirFactory fixedSizeReservoir(final Clock clock, final int size, final Supplier<Random> randomSupplier) {
        return new ExemplarReservoirFactory(){

            @Override
            public DoubleExemplarReservoir createDoubleExemplarReservoir() {
                return RandomFixedSizeExemplarReservoir.create(clock, size, randomSupplier);
            }

            @Override
            public LongExemplarReservoir createLongExemplarReservoir() {
                return RandomFixedSizeExemplarReservoir.create(clock, size, randomSupplier);
            }
        };
    }

    public static ExemplarReservoirFactory histogramBucketReservoir(final Clock clock, final List<Double> boundaries) {
        return new ExemplarReservoirFactory(){

            @Override
            public DoubleExemplarReservoir createDoubleExemplarReservoir() {
                return new HistogramExemplarReservoir(clock, boundaries);
            }

            @Override
            public LongExemplarReservoir createLongExemplarReservoir() {
                return new HistogramExemplarReservoir(clock, boundaries);
            }
        };
    }

    public DoubleExemplarReservoir createDoubleExemplarReservoir();

    public LongExemplarReservoir createLongExemplarReservoir();
}

