/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.List;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.DoubleExemplarReservoir;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilterInternal;

class DoubleFilteredExemplarReservoir
implements DoubleExemplarReservoir {
    private final ExemplarFilterInternal filter;
    private final DoubleExemplarReservoir reservoir;

    DoubleFilteredExemplarReservoir(ExemplarFilterInternal filter, DoubleExemplarReservoir reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerDoubleMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<DoubleExemplarData> collectAndResetDoubles(Attributes pointAttributes) {
        return this.reservoir.collectAndResetDoubles(pointAttributes);
    }
}

