/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics;

import java.util.function.Consumer;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.DoubleUpDownCounter;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.InstrumentValueType;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.SdkMeter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

class SdkDoubleUpDownCounter
extends AbstractInstrument
implements DoubleUpDownCounter {
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkDoubleUpDownCounter(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void add(double increment, Attributes attributes, Context context) {
        this.storage.recordDouble(increment, attributes, context);
    }

    @Override
    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    static class SdkDoubleUpDownCounterBuilder
    implements DoubleUpDownCounterBuilder {
        final InstrumentBuilder builder;

        SdkDoubleUpDownCounterBuilder(SdkMeter sdkMeter, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.DOUBLE, sdkMeter).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public DoubleUpDownCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleUpDownCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleUpDownCounter build() {
            return this.builder.buildSynchronousInstrument(SdkDoubleUpDownCounter::new);
        }

        @Override
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

