/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ExceptionAttributeResolver;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ScopeConfigurator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkLoggerProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.internal.LoggerConfig;

public final class SdkLoggerProviderUtil {
    private SdkLoggerProviderUtil() {
    }

    public static void setLoggerConfigurator(SdkLoggerProvider sdkLoggerProvider, ScopeConfigurator<LoggerConfig> scopeConfigurator) {
        try {
            Method method = SdkLoggerProvider.class.getDeclaredMethod("setLoggerConfigurator", ScopeConfigurator.class);
            method.setAccessible(true);
            method.invoke((Object)sdkLoggerProvider, scopeConfigurator);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setLoggerConfigurator on SdkLoggerProvider", e);
        }
    }

    public static SdkLoggerProviderBuilder setLoggerConfigurator(SdkLoggerProviderBuilder sdkLoggerProviderBuilder, ScopeConfigurator<LoggerConfig> loggerConfigurator) {
        try {
            Method method = SdkLoggerProviderBuilder.class.getDeclaredMethod("setLoggerConfigurator", ScopeConfigurator.class);
            method.setAccessible(true);
            method.invoke((Object)sdkLoggerProviderBuilder, loggerConfigurator);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setLoggerConfigurator on SdkLoggerProviderBuilder", e);
        }
        return sdkLoggerProviderBuilder;
    }

    public static SdkLoggerProviderBuilder addLoggerConfiguratorCondition(SdkLoggerProviderBuilder sdkLoggerProviderBuilder, Predicate<InstrumentationScopeInfo> scopeMatcher, LoggerConfig loggerConfig) {
        try {
            Method method = SdkLoggerProviderBuilder.class.getDeclaredMethod("addLoggerConfiguratorCondition", Predicate.class, LoggerConfig.class);
            method.setAccessible(true);
            method.invoke((Object)sdkLoggerProviderBuilder, scopeMatcher, loggerConfig);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling addLoggerConfiguratorCondition on SdkLoggerProviderBuilder", e);
        }
        return sdkLoggerProviderBuilder;
    }

    public static void setExceptionAttributeResolver(SdkLoggerProviderBuilder sdkLoggerProviderBuilder, ExceptionAttributeResolver exceptionAttributeResolver) {
        try {
            Method method = SdkLoggerProviderBuilder.class.getDeclaredMethod("setExceptionAttributeResolver", ExceptionAttributeResolver.class);
            method.setAccessible(true);
            method.invoke((Object)sdkLoggerProviderBuilder, exceptionAttributeResolver);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setExceptionAttributeResolver on SdkLoggerProviderBuilder", e);
        }
    }
}

