/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InternalTelemetryVersion;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ComponentId;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.DaemonThreadFactory;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.LogRecordProcessor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export.BatchLogRecordProcessorBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export.LogRecordExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export.LogRecordProcessorInstrumentation;

public final class BatchLogRecordProcessor
implements LogRecordProcessor {
    private static final ComponentId COMPONENT_ID = ComponentId.generateLazy("batching_log_processor");
    private static final String WORKER_THREAD_NAME = BatchLogRecordProcessor.class.getSimpleName() + "_WorkerThread";
    private final Worker worker;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static BatchLogRecordProcessorBuilder builder(LogRecordExporter logRecordExporter) {
        return new BatchLogRecordProcessorBuilder(logRecordExporter);
    }

    BatchLogRecordProcessor(LogRecordExporter logRecordExporter, Supplier<MeterProvider> meterProvider, InternalTelemetryVersion telemetryVersion, long scheduleDelayNanos, int maxQueueSize, int maxExportBatchSize, long exporterTimeoutNanos) {
        this.worker = new Worker(logRecordExporter, meterProvider, telemetryVersion, scheduleDelayNanos, maxExportBatchSize, exporterTimeoutNanos, new ArrayBlockingQueue(maxQueueSize), maxQueueSize);
        Thread workerThread = new DaemonThreadFactory(WORKER_THREAD_NAME).newThread(this.worker);
        workerThread.start();
    }

    @Override
    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        this.worker.addLog(logRecord);
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        return this.worker.shutdown();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.worker.forceFlush();
    }

    public LogRecordExporter getLogRecordExporter() {
        return this.worker.logRecordExporter;
    }

    List<LogRecordData> getBatch() {
        return this.worker.batch;
    }

    public String toString() {
        return "BatchLogRecordProcessor{logRecordExporter=" + this.worker.logRecordExporter + ", scheduleDelayNanos=" + this.worker.scheduleDelayNanos + ", maxExportBatchSize=" + this.worker.maxExportBatchSize + ", exporterTimeoutNanos=" + this.worker.exporterTimeoutNanos + '}';
    }

    private static final class Worker
    implements Runnable {
        private static final Logger logger = Logger.getLogger(Worker.class.getName());
        private final LogRecordProcessorInstrumentation logProcessorInstrumentation;
        private final LogRecordExporter logRecordExporter;
        private final long scheduleDelayNanos;
        private final int maxExportBatchSize;
        private final long exporterTimeoutNanos;
        private long nextExportTime;
        private final Queue<ReadWriteLogRecord> queue;
        private final AtomicInteger logsNeeded = new AtomicInteger(Integer.MAX_VALUE);
        private final BlockingQueue<Boolean> signal;
        private final AtomicReference<CompletableResultCode> flushRequested = new AtomicReference();
        private volatile boolean continueWork = true;
        private final ArrayList<LogRecordData> batch;
        private final long maxQueueSize;

        private Worker(LogRecordExporter logRecordExporter, Supplier<MeterProvider> meterProvider, InternalTelemetryVersion telemetryVersion, long scheduleDelayNanos, int maxExportBatchSize, long exporterTimeoutNanos, Queue<ReadWriteLogRecord> queue, long maxQueueSize) {
            this.logRecordExporter = logRecordExporter;
            this.scheduleDelayNanos = scheduleDelayNanos;
            this.maxExportBatchSize = maxExportBatchSize;
            this.exporterTimeoutNanos = exporterTimeoutNanos;
            this.queue = queue;
            this.signal = new ArrayBlockingQueue<Boolean>(1);
            this.logProcessorInstrumentation = LogRecordProcessorInstrumentation.get(telemetryVersion, COMPONENT_ID, meterProvider);
            this.maxQueueSize = maxQueueSize;
            this.batch = new ArrayList(this.maxExportBatchSize);
        }

        private void addLog(ReadWriteLogRecord logData) {
            this.logProcessorInstrumentation.buildQueueMetricsOnce(this.maxQueueSize, this.queue::size);
            if (!this.queue.offer(logData)) {
                this.logProcessorInstrumentation.dropLogs(1);
            } else if (this.queue.size() >= this.logsNeeded.get()) {
                this.signal.offer(true);
            }
        }

        @Override
        public void run() {
            this.updateNextExportTime();
            while (this.continueWork) {
                if (this.flushRequested.get() != null) {
                    this.flush();
                }
                while (!this.queue.isEmpty() && this.batch.size() < this.maxExportBatchSize) {
                    this.batch.add(this.queue.poll().toLogRecordData());
                }
                if (this.batch.size() >= this.maxExportBatchSize || System.nanoTime() >= this.nextExportTime) {
                    this.exportCurrentBatch();
                    this.updateNextExportTime();
                }
                if (!this.queue.isEmpty()) continue;
                try {
                    long pollWaitTime = this.nextExportTime - System.nanoTime();
                    if (pollWaitTime <= 0L) continue;
                    this.logsNeeded.set(this.maxExportBatchSize - this.batch.size());
                    this.signal.poll(pollWaitTime, TimeUnit.NANOSECONDS);
                    this.logsNeeded.set(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }

        private void flush() {
            for (int logsToFlush = this.queue.size(); logsToFlush > 0; --logsToFlush) {
                ReadWriteLogRecord logRecord = this.queue.poll();
                assert (logRecord != null);
                this.batch.add(logRecord.toLogRecordData());
                if (this.batch.size() < this.maxExportBatchSize) continue;
                this.exportCurrentBatch();
            }
            this.exportCurrentBatch();
            CompletableResultCode flushResult = this.flushRequested.get();
            if (flushResult != null) {
                flushResult.succeed();
                this.flushRequested.set(null);
            }
        }

        private void updateNextExportTime() {
            this.nextExportTime = System.nanoTime() + this.scheduleDelayNanos;
        }

        private CompletableResultCode shutdown() {
            CompletableResultCode result = new CompletableResultCode();
            CompletableResultCode flushResult = this.forceFlush();
            flushResult.whenComplete(() -> {
                this.continueWork = false;
                CompletableResultCode shutdownResult = this.logRecordExporter.shutdown();
                shutdownResult.whenComplete(() -> {
                    if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                        result.fail();
                    } else {
                        result.succeed();
                    }
                });
            });
            return result;
        }

        private CompletableResultCode forceFlush() {
            CompletableResultCode possibleResult;
            CompletableResultCode flushResult = new CompletableResultCode();
            if (this.flushRequested.compareAndSet(null, flushResult)) {
                this.signal.offer(true);
            }
            return (possibleResult = this.flushRequested.get()) == null ? CompletableResultCode.ofSuccess() : possibleResult;
        }

        private void exportCurrentBatch() {
            String error;
            block5: {
                if (this.batch.isEmpty()) {
                    return;
                }
                error = null;
                try {
                    CompletableResultCode result = this.logRecordExporter.export(Collections.unmodifiableList(this.batch));
                    result.join(this.exporterTimeoutNanos, TimeUnit.NANOSECONDS);
                    if (result.isSuccess()) break block5;
                    logger.log(Level.FINE, "Exporter failed");
                    error = result.getFailureThrowable() != null ? result.getFailureThrowable().getClass().getName() : "export_failed";
                }
                catch (RuntimeException e) {
                    try {
                        logger.log(Level.WARNING, "Exporter threw an Exception", e);
                        error = e.getClass().getName();
                        this.logProcessorInstrumentation.finishLogs(this.batch.size(), error);
                        this.batch.clear();
                    }
                    catch (Throwable throwable) {
                        this.logProcessorInstrumentation.finishLogs(this.batch.size(), error);
                        this.batch.clear();
                        throw throwable;
                    }
                }
            }
            this.logProcessorInstrumentation.finishLogs(this.batch.size(), error);
            this.batch.clear();
        }
    }
}

