/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs;

import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributeKey;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Value;
import org.apache.shardingsphere.shade.io.opentelemetry.api.logs.Severity;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.SpanContext;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.AttributesMap;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.LogLimits;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkLogRecordData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;

@ThreadSafe
class SdkReadWriteLogRecord
implements ReadWriteLogRecord {
    protected final LogLimits logLimits;
    protected final Resource resource;
    protected final InstrumentationScopeInfo instrumentationScopeInfo;
    protected final long timestampEpochNanos;
    protected final long observedTimestampEpochNanos;
    protected final SpanContext spanContext;
    protected final Severity severity;
    @Nullable
    protected final String severityText;
    @Nullable
    protected final Value<?> body;
    @Nullable
    protected String eventName;
    private final Object lock = new Object();
    @Nullable
    private AttributesMap attributes;

    protected SdkReadWriteLogRecord(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, @Nullable Value<?> body, @Nullable AttributesMap attributes, @Nullable String eventName) {
        this.logLimits = logLimits;
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = severityText;
        this.body = body;
        this.eventName = eventName;
        this.attributes = attributes;
    }

    static SdkReadWriteLogRecord create(LogLimits logLimits, Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long timestampEpochNanos, long observedTimestampEpochNanos, SpanContext spanContext, Severity severity, @Nullable String severityText, @Nullable Value<?> body, @Nullable AttributesMap attributes, @Nullable String eventName) {
        return new SdkReadWriteLogRecord(logLimits, resource, instrumentationScopeInfo, timestampEpochNanos, observedTimestampEpochNanos, spanContext, severity, severityText, body, attributes, eventName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadWriteLogRecord setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getImmutableAttributes() {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return Attributes.empty();
            }
            return this.attributes.immutableCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogRecordData toLogRecordData() {
        Object object = this.lock;
        synchronized (object) {
            return SdkLogRecordData.create(this.resource, this.instrumentationScopeInfo, this.timestampEpochNanos, this.observedTimestampEpochNanos, this.spanContext, this.severity, this.severityText, this.body, this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues(), this.eventName);
        }
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public long getTimestampEpochNanos() {
        return this.timestampEpochNanos;
    }

    @Override
    public long getObservedTimestampEpochNanos() {
        return this.observedTimestampEpochNanos;
    }

    @Override
    public SpanContext getSpanContext() {
        return this.spanContext;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    @Nullable
    public String getSeverityText() {
        return this.severityText;
    }

    @Override
    @Nullable
    public Value<?> getBodyValue() {
        return this.body;
    }

    @Override
    public Attributes getAttributes() {
        return this.getImmutableAttributes();
    }

    @Override
    @Nullable
    public String getEventName() {
        return this.eventName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getAttribute(AttributeKey<T> key) {
        Object object = this.lock;
        synchronized (object) {
            if (this.attributes == null || this.attributes.isEmpty()) {
                return null;
            }
            return this.attributes.get(key);
        }
    }
}

