/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.Clock;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ExceptionAttributeResolver;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.LogLimits;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.LogRecordProcessor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkLoggerInstrumentation;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;

final class LoggerSharedState {
    private final Object lock = new Object();
    private final Resource resource;
    private final Supplier<LogLimits> logLimitsSupplier;
    private final LogRecordProcessor logRecordProcessor;
    private final Clock clock;
    private final ExceptionAttributeResolver exceptionAttributeResolver;
    private final SdkLoggerInstrumentation loggerInstrumentation;
    @Nullable
    private volatile CompletableResultCode shutdownResult = null;

    LoggerSharedState(Resource resource, Supplier<LogLimits> logLimitsSupplier, LogRecordProcessor logRecordProcessor, Clock clock, ExceptionAttributeResolver exceptionAttributeResolver, SdkLoggerInstrumentation loggerInstrumentation) {
        this.resource = resource;
        this.logLimitsSupplier = logLimitsSupplier;
        this.logRecordProcessor = logRecordProcessor;
        this.clock = clock;
        this.exceptionAttributeResolver = exceptionAttributeResolver;
        this.loggerInstrumentation = loggerInstrumentation;
    }

    Resource getResource() {
        return this.resource;
    }

    LogLimits getLogLimits() {
        return this.logLimitsSupplier.get();
    }

    LogRecordProcessor getLogRecordProcessor() {
        return this.logRecordProcessor;
    }

    Clock getClock() {
        return this.clock;
    }

    ExceptionAttributeResolver getExceptionAttributeResolver() {
        return this.exceptionAttributeResolver;
    }

    SdkLoggerInstrumentation getLoggerInstrumentation() {
        return this.loggerInstrumentation;
    }

    boolean hasBeenShutdown() {
        return this.shutdownResult != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableResultCode shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownResult != null) {
                return this.shutdownResult;
            }
            this.shutdownResult = this.logRecordProcessor.shutdown();
            return this.shutdownResult;
        }
    }
}

