/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.GlobUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ScopeConfigurator;

public final class ScopeConfiguratorBuilder<T> {
    @Nullable
    private final ScopeConfigurator<T> baseScopeConfigurator;
    @Nullable
    private T defaultScopeConfig;
    private final List<Condition<T>> conditions = new ArrayList<Condition<T>>();

    ScopeConfiguratorBuilder(@Nullable ScopeConfigurator<T> baseScopeConfigurator) {
        this.baseScopeConfigurator = baseScopeConfigurator;
    }

    public ScopeConfiguratorBuilder<T> setDefault(T defaultScopeConfig) {
        this.defaultScopeConfig = defaultScopeConfig;
        return this;
    }

    public ScopeConfiguratorBuilder<T> addCondition(Predicate<InstrumentationScopeInfo> scopePredicate, T scopeConfig) {
        this.conditions.add(new Condition(scopePredicate, scopeConfig));
        return this;
    }

    public static Predicate<InstrumentationScopeInfo> nameMatchesGlob(String globPattern) {
        return new ScopeNameMatcher(GlobUtil.createGlobPatternPredicate(globPattern));
    }

    public static Predicate<InstrumentationScopeInfo> nameEquals(String scopeName) {
        return new ScopeNameMatcher(name -> name.equals(scopeName));
    }

    public ScopeConfigurator<T> build() {
        return new ScopeConfiguratorImpl(this.baseScopeConfigurator, this.defaultScopeConfig, this.conditions);
    }

    private static final class Condition<T> {
        private final Predicate<InstrumentationScopeInfo> scopeMatcher;
        private final T scopeConfig;

        private Condition(Predicate<InstrumentationScopeInfo> scopeMatcher, T scopeConfig) {
            this.scopeMatcher = scopeMatcher;
            this.scopeConfig = scopeConfig;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "Condition{", "}");
            joiner.add("scopeMatcher=" + this.scopeMatcher);
            joiner.add("scopeConfig=" + this.scopeConfig);
            return joiner.toString();
        }
    }

    private static class ScopeNameMatcher
    implements Predicate<InstrumentationScopeInfo> {
        private final Predicate<String> nameMatcher;

        private ScopeNameMatcher(Predicate<String> nameMatcher) {
            this.nameMatcher = nameMatcher;
        }

        @Override
        public boolean test(InstrumentationScopeInfo scopeInfo) {
            return this.nameMatcher.test(scopeInfo.getName());
        }

        public String toString() {
            return "ScopeNameMatcher{nameMatcher=" + this.nameMatcher + "}";
        }
    }

    private static class ScopeConfiguratorImpl<T>
    implements ScopeConfigurator<T> {
        @Nullable
        private final ScopeConfigurator<T> baseScopeConfigurator;
        @Nullable
        private final T defaultScopeConfig;
        private final List<Condition<T>> conditions;

        private ScopeConfiguratorImpl(@Nullable ScopeConfigurator<T> baseScopeConfigurator, @Nullable T defaultScopeConfig, List<Condition<T>> conditions) {
            this.baseScopeConfigurator = baseScopeConfigurator;
            this.defaultScopeConfig = defaultScopeConfig;
            this.conditions = conditions;
        }

        @Override
        @Nullable
        public T apply(InstrumentationScopeInfo scopeInfo) {
            Object scopeConfig;
            if (this.baseScopeConfigurator != null && (scopeConfig = this.baseScopeConfigurator.apply(scopeInfo)) != null) {
                return (T)scopeConfig;
            }
            for (Condition<T> condition : this.conditions) {
                if (!((Condition)condition).scopeMatcher.test(scopeInfo)) continue;
                return (T)((Condition)condition).scopeConfig;
            }
            return this.defaultScopeConfig;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "ScopeConfiguratorImpl{", "}");
            if (this.baseScopeConfigurator != null) {
                joiner.add("baseScopeConfigurator=" + this.baseScopeConfigurator);
            }
            if (this.defaultScopeConfig != null) {
                joiner.add("defaultScopeConfig=" + this.defaultScopeConfig);
            }
            joiner.add("conditions=" + this.conditions.stream().map(Objects::toString).collect(Collectors.joining(",", "[", "]")));
            return joiner.toString();
        }
    }
}

