/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class GlobUtil {
    private GlobUtil() {
    }

    public static Predicate<String> createGlobPatternPredicate(String globPattern) {
        Pattern pattern = null;
        for (int i = 0; i < globPattern.length(); ++i) {
            char c = globPattern.charAt(i);
            if (c != '*' && c != '?') continue;
            pattern = GlobUtil.toRegexPattern(globPattern);
            break;
        }
        return new GlobPatternPredicate(globPattern, pattern);
    }

    private static Pattern toRegexPattern(String globPattern) {
        int tokenStart = -1;
        StringBuilder patternBuilder = new StringBuilder();
        for (int i = 0; i < globPattern.length(); ++i) {
            char c = globPattern.charAt(i);
            if (c == '*' || c == '?') {
                if (tokenStart != -1) {
                    patternBuilder.append(Pattern.quote(globPattern.substring(tokenStart, i)));
                    tokenStart = -1;
                }
                if (c == '*') {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append(".");
                continue;
            }
            if (tokenStart != -1) continue;
            tokenStart = i;
        }
        if (tokenStart != -1) {
            patternBuilder.append(Pattern.quote(globPattern.substring(tokenStart)));
        }
        return Pattern.compile(patternBuilder.toString());
    }

    private static class GlobPatternPredicate
    implements Predicate<String> {
        private final String globPattern;
        @Nullable
        private final Pattern pattern;

        private GlobPatternPredicate(String globPattern, @Nullable Pattern pattern) {
            this.globPattern = globPattern;
            this.pattern = pattern;
        }

        @Override
        public boolean test(String s) {
            if (this.globPattern.equals("*")) {
                return true;
            }
            if (this.pattern != null) {
                return this.pattern.matcher(s).matches();
            }
            return this.globPattern.equalsIgnoreCase(s);
        }

        public String toString() {
            return "GlobPatternPredicate{globPattern=" + this.globPattern + "}";
        }
    }
}

