/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.common;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.Clock;

@ThreadSafe
final class SystemClock
implements Clock {
    private static final SystemClock INSTANCE = new SystemClock();

    private SystemClock() {
    }

    static Clock getInstance() {
        return INSTANCE;
    }

    @Override
    public long now() {
        return this.now(true);
    }

    @Override
    public long now(boolean highPrecision) {
        if (highPrecision) {
            Instant now = java.time.Clock.systemUTC().instant();
            return TimeUnit.SECONDS.toNanos(now.getEpochSecond()) + (long)now.getNano();
        }
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    public String toString() {
        return "SystemClock{}";
    }
}

