/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class CompletableResultCode {
    private static final CompletableResultCode SUCCESS = new CompletableResultCode().succeed();
    private static final CompletableResultCode FAILURE = new CompletableResultCode().fail();
    @Nullable
    private Boolean succeeded = null;
    @Nullable
    private Throwable throwable = null;
    private final List<Runnable> completionActions = new ArrayList<Runnable>();
    private final Object lock = new Object();

    public static CompletableResultCode ofSuccess() {
        return SUCCESS;
    }

    public static CompletableResultCode ofFailure() {
        return FAILURE;
    }

    public static CompletableResultCode ofExceptionalFailure(Throwable throwable) {
        return new CompletableResultCode().failExceptionally(throwable);
    }

    public static CompletableResultCode ofAll(Collection<CompletableResultCode> codes) {
        if (codes.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result = new CompletableResultCode();
        AtomicInteger pending = new AtomicInteger(codes.size());
        AtomicBoolean failed = new AtomicBoolean();
        AtomicReference throwableRef = new AtomicReference();
        for (CompletableResultCode code : codes) {
            code.whenComplete(() -> {
                if (!code.isSuccess()) {
                    failed.set(true);
                    Throwable codeThrowable = code.getFailureThrowable();
                    if (codeThrowable != null) {
                        throwableRef.compareAndSet(null, codeThrowable);
                    }
                }
                if (pending.decrementAndGet() == 0) {
                    if (failed.get()) {
                        result.failInternal((Throwable)throwableRef.get());
                    } else {
                        result.succeed();
                    }
                }
            });
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableResultCode succeed() {
        Object object = this.lock;
        synchronized (object) {
            if (this.succeeded == null) {
                this.succeeded = true;
                for (Runnable action : this.completionActions) {
                    action.run();
                }
            }
        }
        return this;
    }

    public CompletableResultCode fail() {
        return this.failInternal(null);
    }

    public CompletableResultCode failExceptionally(@Nullable Throwable throwable) {
        return this.failInternal(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableResultCode failInternal(@Nullable Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.succeeded == null) {
                this.succeeded = false;
                this.throwable = throwable;
                for (Runnable action : this.completionActions) {
                    action.run();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuccess() {
        Object object = this.lock;
        synchronized (object) {
            return this.succeeded != null && this.succeeded != false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Throwable getFailureThrowable() {
        Object object = this.lock;
        synchronized (object) {
            return this.throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableResultCode whenComplete(Runnable action) {
        boolean runNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.succeeded != null) {
                runNow = true;
            } else {
                this.completionActions.add(action);
            }
        }
        if (runNow) {
            action.run();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.succeeded != null;
        }
    }

    public CompletableResultCode join(long timeout2, TimeUnit unit) {
        if (this.isDone()) {
            return this;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.whenComplete(latch::countDown);
        try {
            if (!latch.await(timeout2, unit)) {
                return this;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this;
    }
}

