/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.InstrumentationUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.metrics.ExporterInstrumentation;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.OtelToZipkinSpanTransformer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InternalTelemetryVersion;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ComponentId;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.StandardComponentId;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.SpanData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;
import org.apache.shardingsphere.shade.zipkin2.Span;
import org.apache.shardingsphere.shade.zipkin2.reporter.BytesEncoder;
import org.apache.shardingsphere.shade.zipkin2.reporter.BytesMessageSender;
import org.apache.shardingsphere.shade.zipkin2.reporter.Encoding;

public final class ZipkinSpanExporter
implements SpanExporter {
    public static final Logger baseLogger = Logger.getLogger(ZipkinSpanExporter.class.getName());
    public static final String DEFAULT_ENDPOINT = "http://localhost:9411/api/v2/spans";
    private final ThrottlingLogger logger = new ThrottlingLogger(baseLogger);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final ZipkinSpanExporterBuilder builder;
    private final BytesEncoder<Span> encoder;
    private final BytesMessageSender sender;
    private final ExporterInstrumentation exporterMetrics;
    private final OtelToZipkinSpanTransformer transformer;

    ZipkinSpanExporter(ZipkinSpanExporterBuilder builder, BytesEncoder<Span> encoder, BytesMessageSender sender, Supplier<MeterProvider> meterProviderSupplier, InternalTelemetryVersion internalTelemetryVersion, String endpoint, OtelToZipkinSpanTransformer transformer) {
        this.builder = builder;
        this.encoder = encoder;
        this.sender = sender;
        this.transformer = transformer;
        StandardComponentId.ExporterType exporterType = sender.encoding() == Encoding.JSON ? StandardComponentId.ExporterType.ZIPKIN_HTTP_JSON_SPAN_EXPORTER : StandardComponentId.ExporterType.ZIPKIN_HTTP_SPAN_EXPORTER;
        this.exporterMetrics = new ExporterInstrumentation(internalTelemetryVersion, meterProviderSupplier, ComponentId.generateLazy(exporterType), endpoint);
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spanDataList) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        int numItems = spanDataList.size();
        ExporterInstrumentation.Recording metricRecording = this.exporterMetrics.startRecordingExport(numItems);
        ArrayList<byte[]> encodedSpans = new ArrayList<byte[]>(numItems);
        for (SpanData spanData : spanDataList) {
            Span zipkinSpan = this.transformer.generateSpan(spanData);
            encodedSpans.add(this.encoder.encode(zipkinSpan));
        }
        CompletableResultCode resultCode = new CompletableResultCode();
        InstrumentationUtil.suppressInstrumentation(() -> {
            try {
                this.sender.send(encodedSpans);
                metricRecording.finishSuccessful();
                resultCode.succeed();
            }
            catch (IOException | RuntimeException e) {
                metricRecording.finishFailed(e);
                this.logger.log(Level.WARNING, "Failed to export spans", e);
                resultCode.fail();
            }
        });
        return resultCode;
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        try {
            this.sender.close();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Exception while closing the Zipkin Sender instance", e);
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        return "ZipkinSpanExporter{" + this.builder.toString(false) + "}";
    }

    public static ZipkinSpanExporterBuilder builder() {
        return new ZipkinSpanExporterBuilder();
    }
}

