/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Value;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.common.ExtendedAttributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.internal.InternalExtendedAttributeKeyImpl;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.AnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.ArrayAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.ExtendedAttributeKeyValueStatelessMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.KeyValueListAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.logs.v1.internal.LogRecord;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.data.internal.ExtendedLogRecordData;

public class IncubatingUtil {
    private static final boolean INCUBATOR_AVAILABLE;
    private static final byte[] EMPTY_BYTES;
    private static final KeyValueMarshaler[] EMPTY_REPEATED;

    private IncubatingUtil() {
    }

    public static boolean isExtendedLogRecordData(LogRecordData logRecordData) {
        return INCUBATOR_AVAILABLE && logRecordData instanceof ExtendedLogRecordData;
    }

    public static KeyValueMarshaler[] createdExtendedAttributesMarhsalers(LogRecordData logRecordData) {
        return IncubatingUtil.createForExtendedAttributes(IncubatingUtil.getExtendedAttributes(logRecordData));
    }

    public static int extendedAttributesSize(LogRecordData logRecordData) {
        return IncubatingUtil.getExtendedAttributes(logRecordData).size();
    }

    private static KeyValueMarshaler[] createForExtendedAttributes(ExtendedAttributes attributes) {
        if (attributes.isEmpty()) {
            return EMPTY_REPEATED;
        }
        final KeyValueMarshaler[] marshalers = new KeyValueMarshaler[attributes.size()];
        attributes.forEach(new BiConsumer<ExtendedAttributeKey<?>, Object>(){
            int index = 0;

            @Override
            public void accept(ExtendedAttributeKey<?> attributeKey, Object o) {
                marshalers[this.index++] = IncubatingUtil.create(attributeKey, o);
            }
        });
        return marshalers;
    }

    private static KeyValueMarshaler create(ExtendedAttributeKey<?> attributeKey, Object value) {
        byte[] keyUtf8 = attributeKey.getKey().isEmpty() ? EMPTY_BYTES : (attributeKey instanceof InternalExtendedAttributeKeyImpl ? ((InternalExtendedAttributeKeyImpl)attributeKey).getKeyUtf8() : attributeKey.getKey().getBytes(StandardCharsets.UTF_8));
        switch (attributeKey.getType()) {
            case STRING: {
                return new KeyValueMarshaler(keyUtf8, StringAnyValueMarshaler.create((String)value));
            }
            case LONG: {
                return new KeyValueMarshaler(keyUtf8, IntAnyValueMarshaler.create((Long)value));
            }
            case BOOLEAN: {
                return new KeyValueMarshaler(keyUtf8, BoolAnyValueMarshaler.create((Boolean)value));
            }
            case DOUBLE: {
                return new KeyValueMarshaler(keyUtf8, DoubleAnyValueMarshaler.create((Double)value));
            }
            case STRING_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createString((List)value));
            }
            case LONG_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createInt((List)value));
            }
            case BOOLEAN_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createBool((List)value));
            }
            case DOUBLE_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, ArrayAnyValueMarshaler.createDouble((List)value));
            }
            case EXTENDED_ATTRIBUTES: {
                return new KeyValueMarshaler(keyUtf8, new KeyValueListAnyValueMarshaler(new KeyValueListAnyValueMarshaler.KeyValueListMarshaler(IncubatingUtil.createForExtendedAttributes((ExtendedAttributes)value))));
            }
            case VALUE: {
                return new KeyValueMarshaler(keyUtf8, AnyValueMarshaler.create((Value)value));
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type.");
    }

    public static int sizeExtendedAttributes(LogRecordData log, MarshalerContext context) {
        return ExtendedAttributeKeyValueStatelessMarshaler.sizeExtendedAttributes(LogRecord.ATTRIBUTES, IncubatingUtil.getExtendedAttributes(log), context);
    }

    public static void serializeExtendedAttributes(Serializer output, LogRecordData log, MarshalerContext context) throws IOException {
        ExtendedAttributeKeyValueStatelessMarshaler.serializeExtendedAttributes(output, LogRecord.ATTRIBUTES, IncubatingUtil.getExtendedAttributes(log), context);
    }

    private static ExtendedAttributes getExtendedAttributes(LogRecordData logRecordData) {
        if (!(logRecordData instanceof ExtendedLogRecordData)) {
            throw new IllegalArgumentException("logRecordData must be ExtendedLogRecordData");
        }
        return ((ExtendedLogRecordData)logRecordData).getExtendedAttributes();
    }

    static {
        boolean incubatorAvailable = false;
        try {
            Class.forName("org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.common.ExtendedAttributes");
            incubatorAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INCUBATOR_AVAILABLE = incubatorAvailable;
        EMPTY_BYTES = new byte[0];
        EMPTY_REPEATED = new KeyValueMarshaler[0];
    }
}

