/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal;

import java.io.IOException;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.FallbackStringEncoder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StringEncoder;

abstract class AbstractStringEncoder
implements StringEncoder {
    private final FallbackStringEncoder fallback = new FallbackStringEncoder();
    private static final int MAX_INNER_LOOP_SIZE = 2040;
    private static final long MOST_SIGNIFICANT_BIT_MASK = -9187201950435737472L;

    AbstractStringEncoder() {
    }

    @Override
    public final void writeUtf8(CodedOutputStream output, String string, int utf8Length) throws IOException {
        if (string.length() == utf8Length && this.isLatin1(string)) {
            byte[] bytes = this.getStringBytes(string);
            output.write(bytes, 0, bytes.length);
        } else {
            this.fallback.writeUtf8(output, string, utf8Length);
        }
    }

    @Override
    public final int getUtf8Size(String string) {
        if (this.isLatin1(string)) {
            byte[] bytes = this.getStringBytes(string);
            return string.length() + this.countNegative(bytes);
        }
        return this.fallback.getUtf8Size(string);
    }

    protected abstract byte[] getStringBytes(String var1);

    protected abstract boolean isLatin1(String var1);

    protected abstract long getLong(byte[] var1, int var2);

    private int countNegative(byte[] bytes) {
        int i;
        int count = 0;
        int offset = 0;
        for (i = 1; i <= bytes.length / 2040 + 1; ++i) {
            long tmp = 0L;
            int limit = Math.min(i * 2040, bytes.length & 0xFFFFFFF8);
            while (offset < limit) {
                long value = this.getLong(bytes, offset);
                tmp += (value & 0x8080808080808080L) >>> 7;
                offset += 8;
            }
            if (tmp == 0L) continue;
            for (int j = 0; j < 8; ++j) {
                count += (int)(tmp & 0xFFL);
                tmp >>>= 8;
            }
        }
        for (i = offset; i < bytes.length; ++i) {
            count += bytes[i] >>> 31;
        }
        return count;
    }
}

