/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.Utils;
import org.apache.shardingsphere.shade.io.opentelemetry.common.ComponentLoader;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression.Compressor;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression.CompressorProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression.GzipCompressor;

public final class CompressorUtil {
    private static final Map<String, Compressor> compressorRegistry = CompressorUtil.buildCompressorRegistry(ComponentLoader.forClassLoader(CompressorUtil.class.getClassLoader()));

    private CompressorUtil() {
    }

    @Nullable
    public static Compressor validateAndResolveCompressor(String compressionMethod) {
        return CompressorUtil.validateAndResolveCompressor(compressionMethod, null);
    }

    @Nullable
    public static Compressor validateAndResolveCompressor(String compressionMethod, @Nullable ComponentLoader componentLoader) {
        Map<String, Compressor> registry = componentLoader == null ? compressorRegistry : CompressorUtil.buildCompressorRegistry(componentLoader);
        Set<String> supportedEncodings = registry.keySet();
        Compressor compressor = registry.get(compressionMethod);
        Utils.checkArgument("none".equals(compressionMethod) || compressor != null, "Unsupported compressionMethod. Compression method must be \"none\" or one of: " + supportedEncodings.stream().collect(Collectors.joining(",", "[", "]")));
        return compressor;
    }

    private static Map<String, Compressor> buildCompressorRegistry(ComponentLoader componentLoader) {
        HashMap<String, Compressor> compressors = new HashMap<String, Compressor>();
        for (CompressorProvider spi : componentLoader.load(CompressorProvider.class)) {
            Compressor compressor = spi.getInstance();
            compressors.put(compressor.getEncoding(), compressor);
        }
        compressors.put(GzipCompressor.getInstance().getEncoding(), GzipCompressor.getInstance());
        return compressors;
    }
}

