/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.api.internal;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.OpenTelemetry;

public class IncubatingUtil {
    private IncubatingUtil() {
    }

    public static <T> T incubatingApiIfAvailable(T stableApi, String incubatingClassName) {
        try {
            Class<?> incubatingClass = Class.forName(incubatingClassName);
            Method getInstance = incubatingClass.getDeclaredMethod("getNoop", new Class[0]);
            return (T)getInstance.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return stableApi;
        }
    }

    @Nullable
    public static OpenTelemetry obfuscatedOpenTelemetryIfIncubating(OpenTelemetry openTelemetry) {
        try {
            Class<?> extendedClass = Class.forName("org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.ExtendedOpenTelemetry");
            if (extendedClass.isInstance(openTelemetry)) {
                Class<?> incubatingClass = Class.forName("org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.internal.ObfuscatedExtendedOpenTelemetry");
                return (OpenTelemetry)incubatingClass.getDeclaredConstructor(extendedClass).newInstance(extendedClass.cast(openTelemetry));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

