/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.tracing.core.advice;

import org.apache.shardingsphere.agent.api.advice.TargetAdviceMethod;
import org.apache.shardingsphere.agent.api.advice.TargetAdviceObject;
import org.apache.shardingsphere.agent.plugin.core.advice.AbstractInstanceMethodAdvice;
import org.apache.shardingsphere.agent.plugin.core.util.AgentReflectionUtils;
import org.apache.shardingsphere.agent.plugin.tracing.core.RootSpanContext;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;

public abstract class TracingJDBCExecutorCallbackAdvice<T>
extends AbstractInstanceMethodAdvice {
    protected static final String OPERATION_NAME = "/ShardingSphere/executeSQL/";

    public final void beforeMethod(TargetAdviceObject target, TargetAdviceMethod method, Object[] args, String pluginType) {
        JDBCExecutionUnit executionUnit = (JDBCExecutionUnit)args[0];
        ResourceMetaData resourceMetaData = (ResourceMetaData)AgentReflectionUtils.getFieldValue((Object)target, (String)"resourceMetaData");
        ConnectionProperties connectionProps = ((StorageUnit)resourceMetaData.getStorageUnits().get(executionUnit.getExecutionUnit().getDataSourceName())).getConnectionProperties();
        DatabaseType storageType = ((StorageUnit)resourceMetaData.getStorageUnits().get(executionUnit.getExecutionUnit().getDataSourceName())).getStorageType();
        this.recordExecuteInfo(RootSpanContext.get(), target, executionUnit, (Boolean)args[1], connectionProps, storageType);
    }

    protected abstract void recordExecuteInfo(T var1, TargetAdviceObject var2, JDBCExecutionUnit var3, boolean var4, ConnectionProperties var5, DatabaseType var6);
}

