/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.core.util;

import java.lang.reflect.Field;
import java.util.Optional;
import lombok.Generated;

public final class AgentReflectionUtils {
    public static <T> T getFieldValue(Object target, String fieldName) {
        Optional<Field> field = AgentReflectionUtils.findField(fieldName, target.getClass());
        if (field.isPresent()) {
            return AgentReflectionUtils.getFieldValue(target, field.get());
        }
        throw new IllegalStateException(String.format("Can not find field name `%s` in class %s.", fieldName, target.getClass()));
    }

    private static <T> T getFieldValue(Object target, Field field) {
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object result = field.get(target);
        if (!accessible) {
            field.setAccessible(false);
        }
        return (T)result;
    }

    private static Optional<Field> findField(String fieldName, Class<?> targetClass) {
        for (Class<?> currentTargetClass = targetClass; Object.class != currentTargetClass; currentTargetClass = currentTargetClass.getSuperclass()) {
            try {
                return Optional.of(currentTargetClass.getDeclaredField(fieldName));
            }
            catch (NoSuchFieldException ignored) {
                continue;
            }
        }
        return Optional.empty();
    }

    @Generated
    private AgentReflectionUtils() {
    }
}

