/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception.converter;

import io.netty.channel.ConnectTimeoutException;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionConverter;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectTimeoutExceptionConverter
implements ExceptionConverter<ConnectTimeoutException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectTimeoutExceptionConverter.class);
    public static final int ORDER = Short.MAX_VALUE;

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean canConvert(Throwable throwable) {
        return throwable instanceof ConnectTimeoutException;
    }

    @Override
    public InvocationException convert(@Nullable Invocation invocation, ConnectTimeoutException throwable, Response.StatusType genericStatus) {
        LOGGER.info("connection timed out, Details: {}.", (Object)throwable.getMessage());
        return new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, ExceptionConverter.getGenericCode(genericStatus), "connection timed out.", (Throwable)throwable);
    }
}

