/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client.tcp;

import io.vertx.core.Context;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.vertx.client.tcp.NetClientWrapper;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpClientConnection;

public abstract class AbstractTcpClientConnectionPool<T extends TcpClientConnection> {
    protected Context context;
    protected NetClientWrapper netClientWrapper;
    protected Map<String, T> tcpClientMap = new ConcurrentHashMapEx();

    public AbstractTcpClientConnectionPool(Context context, NetClientWrapper netClientWrapper) {
        this.context = context;
        this.netClientWrapper = netClientWrapper;
        this.startCheckTimeout(context);
    }

    protected void startCheckTimeout(Context context) {
        context.owner().setPeriodic(TimeUnit.SECONDS.toMillis(1L), this::onCheckTimeout);
    }

    private void onCheckTimeout(Long event) {
        for (TcpClientConnection client : this.tcpClientMap.values()) {
            client.checkTimeout();
        }
    }

    public T findOrCreateClient(String endpoint) {
        return (T)this.tcpClientMap.computeIfAbsent(endpoint, this::create);
    }

    protected abstract T create(String var1);
}

