/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.google.common.eventbus.EventBus;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spectator.api.patterns.ThreadPoolMonitor;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.executor.GroupExecutor;
import org.apache.servicecomb.core.executor.ThreadPoolExecutorEx;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;

public class ThreadPoolMetersInitializer
implements MetricsInitializer {
    public static String REJECTED_COUNT = "threadpool.rejectedCount";
    private Registry registry;

    public void init(GlobalRegistry globalRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        this.registry = globalRegistry.getDefaultRegistry();
        this.createThreadPoolMeters();
    }

    public void createThreadPoolMeters() {
        Map<Executor, Executor> operationExecutors = this.collectionOperationExecutors();
        Map beanExecutors = BeanUtils.getContext().getBeansOfType(Executor.class);
        for (Map.Entry entry : beanExecutors.entrySet()) {
            Executor executor = (Executor)entry.getValue();
            if (!operationExecutors.containsKey(executor)) continue;
            if (GroupExecutor.class.isInstance(executor)) {
                this.createThreadPoolMeters((String)entry.getKey(), (GroupExecutor)executor);
                continue;
            }
            this.createThreadPoolMeters((String)entry.getKey(), executor);
        }
    }

    protected Map<Executor, Executor> collectionOperationExecutors() {
        IdentityHashMap<Executor, Executor> operationExecutors = new IdentityHashMap<Executor, Executor>();
        MicroserviceMeta microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        for (OperationMeta operationMeta : microserviceMeta.getOperations()) {
            operationExecutors.put(operationMeta.getExecutor(), operationMeta.getExecutor());
        }
        return operationExecutors;
    }

    protected void createThreadPoolMeters(String threadPoolName, GroupExecutor groupExecutor) {
        for (int idx = 0; idx < groupExecutor.getExecutorList().size(); ++idx) {
            Executor executor = (Executor)groupExecutor.getExecutorList().get(idx);
            this.createThreadPoolMeters(threadPoolName + "-group" + idx, executor);
        }
    }

    protected void createThreadPoolMeters(String threadPoolName, Executor executor) {
        if (!ThreadPoolExecutor.class.isInstance(executor)) {
            return;
        }
        ThreadPoolMonitor.attach((Registry)this.registry, (ThreadPoolExecutor)((ThreadPoolExecutor)executor), (String)threadPoolName);
        if (executor instanceof ThreadPoolExecutorEx) {
            BasicTag idTag = new BasicTag("id", threadPoolName);
            ((PolledMeter.Builder)((PolledMeter.Builder)PolledMeter.using((Registry)this.registry).withName(REJECTED_COUNT)).withTag((Tag)idTag)).monitorMonotonicCounter((Object)((ThreadPoolExecutorEx)executor), ThreadPoolExecutorEx::getRejectedCount);
        }
    }
}

