/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.snowflake.snowsql.udtfs;

import java.util.stream.Stream;
import org.apache.sedona.snowflake.snowsql.GeometrySerde;
import org.apache.sedona.snowflake.snowsql.annotations.UDTFAnnotations;
import org.locationtech.jts.io.ParseException;

@UDTFAnnotations.TabularFunc(name="ST_Dump", argNames={"geomCollection"})
public class ST_Dump {
    public static Class getOutputClass() {
        return OutputRow.class;
    }

    public Stream<OutputRow> process(byte[] geomCollection) throws ParseException {
        return Stream.of(GeometrySerde.deserialize2List(geomCollection)).map(g2 -> new OutputRow(GeometrySerde.serialize(g2)));
    }

    public static class OutputRow {
        public byte[] geom;

        public OutputRow(byte[] geom) {
            this.geom = geom;
        }
    }
}

