/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.sedona.common.utils.HalfOpenRectangle;
import org.apache.sedona.core.spatialPartitioning.PartitioningUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Tuple2;

public class KDB
extends PartitioningUtils
implements Serializable {
    private final int maxItemsPerNode;
    private final int maxLevels;
    private final Envelope extent;
    private final int level;
    private final List<Envelope> items = new ArrayList<Envelope>();
    private KDB[] children;
    private int leafId = 0;

    public KDB(int maxItemsPerNode, int maxLevels, Envelope extent) {
        this(maxItemsPerNode, maxLevels, 0, extent);
    }

    private KDB(int maxItemsPerNode, int maxLevels, int level, Envelope extent) {
        this.maxItemsPerNode = maxItemsPerNode;
        this.maxLevels = maxLevels;
        this.level = level;
        this.extent = extent;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public int getLeafId() {
        if (!this.isLeaf()) {
            throw new IllegalStateException();
        }
        return this.leafId;
    }

    public Envelope getExtent() {
        return this.extent;
    }

    public void insert(Envelope envelope) {
        if (this.items.size() < this.maxItemsPerNode || this.level >= this.maxLevels) {
            this.items.add(envelope);
        } else {
            if (this.children == null) {
                boolean splitX = this.extent.getWidth() > this.extent.getHeight();
                boolean ok = this.split(splitX);
                if (!ok) {
                    ok = this.split(!splitX);
                }
                if (!ok) {
                    this.items.add(envelope);
                    return;
                }
            }
            for (KDB child : this.children) {
                if (!child.extent.contains(envelope.getMinX(), envelope.getMinY())) continue;
                child.insert(envelope);
                break;
            }
        }
    }

    public void dropElements() {
        this.traverse(new Visitor(){

            @Override
            public boolean visit(KDB tree) {
                tree.items.clear();
                return true;
            }
        });
    }

    public List<KDB> findLeafNodes(final Envelope envelope) {
        final ArrayList<KDB> matches = new ArrayList<KDB>();
        this.traverse(new Visitor(){

            @Override
            public boolean visit(KDB tree) {
                if (!KDB.this.disjoint(tree.getExtent(), envelope)) {
                    if (tree.isLeaf()) {
                        matches.add(tree);
                    }
                    return true;
                }
                return false;
            }
        });
        return matches;
    }

    private boolean disjoint(Envelope r1, Envelope r2) {
        return !r1.intersects(r2) && !r1.covers(r2) && !r2.covers(r1);
    }

    public void traverse(Visitor visitor) {
        if (!visitor.visit(this)) {
            return;
        }
        if (this.children != null) {
            for (KDB child : this.children) {
                child.traverse(visitor);
            }
        }
    }

    public void assignLeafIds() {
        this.traverse(new Visitor(){
            int id = 0;

            @Override
            public boolean visit(KDB tree) {
                if (tree.isLeaf()) {
                    tree.leafId = this.id;
                    ++this.id;
                }
                return true;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean split(boolean splitX) {
        void var4_9;
        Envelope[] splits;
        Comparator<Envelope> comparator = splitX ? new XComparator() : new YComparator();
        Collections.sort(this.items, comparator);
        Envelope middleItem = this.items.get((int)Math.floor(this.items.size() / 2));
        if (splitX) {
            double x = middleItem.getMinX();
            if (!(x > this.extent.getMinX()) || !(x < this.extent.getMaxX())) return false;
            splits = this.splitAtX(this.extent, x);
            XSplitter xSplitter = new XSplitter(x);
        } else {
            double y = middleItem.getMinY();
            if (!(y > this.extent.getMinY()) || !(y < this.extent.getMaxY())) return false;
            splits = this.splitAtY(this.extent, y);
            YSplitter ySplitter = new YSplitter(y);
        }
        this.children = new KDB[2];
        this.children[0] = new KDB(this.maxItemsPerNode, this.maxLevels, this.level + 1, splits[0]);
        this.children[1] = new KDB(this.maxItemsPerNode, this.maxLevels, this.level + 1, splits[1]);
        this.splitItems((Splitter)var4_9);
        return true;
    }

    private void splitItems(Splitter splitter) {
        for (Envelope item : this.items) {
            this.children[splitter.split(item) ? 0 : 1].insert(item);
        }
    }

    private Envelope[] splitAtX(Envelope envelope, double x) {
        assert (envelope.getMinX() < x);
        assert (envelope.getMaxX() > x);
        Envelope[] splits = new Envelope[]{new Envelope(envelope.getMinX(), x, envelope.getMinY(), envelope.getMaxY()), new Envelope(x, envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY())};
        return splits;
    }

    private Envelope[] splitAtY(Envelope envelope, double y) {
        assert (envelope.getMinY() < y);
        assert (envelope.getMaxY() > y);
        Envelope[] splits = new Envelope[]{new Envelope(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), y), new Envelope(envelope.getMinX(), envelope.getMaxX(), y, envelope.getMaxY())};
        return splits;
    }

    @Override
    public Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry geometry) {
        Objects.requireNonNull(geometry, "spatialObject");
        Envelope envelope = geometry.getEnvelopeInternal();
        List<KDB> matchedPartitions = this.findLeafNodes(envelope);
        Point point = geometry instanceof Point ? (Point)geometry : null;
        HashSet<Tuple2> result = new HashSet<Tuple2>();
        for (KDB leaf : matchedPartitions) {
            if (point != null && !new HalfOpenRectangle(leaf.getExtent()).contains(point)) continue;
            result.add(new Tuple2((Object)leaf.getLeafId(), (Object)geometry));
        }
        return result.iterator();
    }

    @Override
    public Set<Integer> getKeys(Geometry geometry) {
        Objects.requireNonNull(geometry, "spatialObject");
        Envelope envelope = geometry.getEnvelopeInternal();
        List<KDB> matchedPartitions = this.findLeafNodes(envelope);
        Point point = geometry instanceof Point ? (Point)geometry : null;
        HashSet<Integer> result = new HashSet<Integer>();
        for (KDB leaf : matchedPartitions) {
            if (point != null && !new HalfOpenRectangle(leaf.getExtent()).contains(point)) continue;
            result.add(leaf.getLeafId());
        }
        return result;
    }

    @Override
    public List<Envelope> fetchLeafZones() {
        final ArrayList<Envelope> leafs = new ArrayList<Envelope>();
        this.traverse(new Visitor(){

            @Override
            public boolean visit(KDB tree) {
                if (tree.isLeaf()) {
                    leafs.add(tree.getExtent());
                }
                return true;
            }
        });
        return leafs;
    }

    private static final class YSplitter
    implements Splitter {
        private final double y;

        private YSplitter(double y) {
            this.y = y;
        }

        @Override
        public boolean split(Envelope envelope) {
            return envelope.getMinY() <= this.y;
        }
    }

    private static final class XSplitter
    implements Splitter {
        private final double x;

        private XSplitter(double x) {
            this.x = x;
        }

        @Override
        public boolean split(Envelope envelope) {
            return envelope.getMinX() <= this.x;
        }
    }

    private static final class YComparator
    implements Comparator<Envelope> {
        private YComparator() {
        }

        @Override
        public int compare(Envelope o1, Envelope o2) {
            double deltaY = o1.getMinY() - o2.getMinY();
            return (int)Math.signum(deltaY != 0.0 ? deltaY : o1.getMinX() - o2.getMinX());
        }
    }

    private static final class XComparator
    implements Comparator<Envelope> {
        private XComparator() {
        }

        @Override
        public int compare(Envelope o1, Envelope o2) {
            double deltaX = o1.getMinX() - o2.getMinX();
            return (int)Math.signum(deltaX != 0.0 ? deltaX : o1.getMinY() - o2.getMinY());
        }
    }

    private static interface Splitter {
        public boolean split(Envelope var1);
    }

    public static interface Visitor {
        public boolean visit(KDB var1);
    }
}

