/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.Formatter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionPoint;

public class LatLonPoints {
    public static boolean betweenLon(double lon, double lonBeg, double lonEnd) {
        lonBeg = LatLonPoints.lonNormal(lonBeg, lon);
        lonEnd = LatLonPoints.lonNormal(lonEnd, lon);
        return lon >= lonBeg && lon <= lonEnd;
    }

    public static double range180(double lon) {
        return LatLonPoints.lonNormal(lon);
    }

    public static double lonNormal360(double lon) {
        return LatLonPoints.lonNormal(lon, 180.0);
    }

    public static double lonNormal(double lon, double center) {
        return center + Math.IEEEremainder(lon - center, 360.0);
    }

    public static double lonNormalFrom(double lon, double start) {
        while (lon < start) {
            lon += 360.0;
        }
        while (lon > start + 360.0) {
            lon -= 360.0;
        }
        return lon;
    }

    public static double lonNormal(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            return Math.IEEEremainder(lon, 360.0);
        }
        return lon;
    }

    public static double lonDiff(double lon1, double lon2) {
        return Math.IEEEremainder(lon1 - lon2, 360.0);
    }

    public static double latNormal(double lat) {
        if (lat < -90.0) {
            return -90.0;
        }
        if (lat > 90.0) {
            return 90.0;
        }
        return lat;
    }

    public static String latToString(double lat, int ndec) {
        boolean is_north;
        boolean bl = is_north = lat >= 0.0;
        if (!is_north) {
            lat = -lat;
        }
        String f = "%." + ndec + "f";
        Formatter latBuff = new Formatter();
        latBuff.format(f, lat);
        latBuff.format("%s", is_north ? "N" : "S");
        return latBuff.toString();
    }

    public static String lonToString(double lon, int ndec) {
        boolean is_east;
        double wlon = LatLonPoints.lonNormal(lon);
        boolean bl = is_east = wlon >= 0.0;
        if (!is_east) {
            wlon = -wlon;
        }
        String f = "%." + ndec + "f";
        Formatter latBuff = new Formatter();
        latBuff.format(f, wlon);
        latBuff.format("%s", is_east ? "E" : "W");
        return latBuff.toString();
    }

    public static boolean isInfinite(ProjectionPoint pt) {
        return pt.getX() == Double.POSITIVE_INFINITY || pt.getX() == Double.NEGATIVE_INFINITY || pt.getY() == Double.POSITIVE_INFINITY || pt.getY() == Double.NEGATIVE_INFINITY;
    }

    public static String toString(LatLonPoint pt, int sigDigits) {
        Formatter sbuff = new Formatter();
        sbuff.format("%s %s", LatLonPoints.latToString(pt.getLatitude(), sigDigits), LatLonPoints.lonToString(pt.getLongitude(), sigDigits));
        return sbuff.toString();
    }
}

