---
layout: blog
title: Announcing the release of Apache Samza 1.1.0
icon: git-pull-request
authors:
    - name: Shanthoosh Venkataraman
      website: 
      image: 
excerpt_separator: <!--more-->
---
<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
# **Announcing the release of Apache Samza 1.1.0**


<!--more-->

We’re thrilled to announce to the release of Apache Samza 1.1.0.

Today Samza forms the backbone of hundreds of real-time production applications across a multitude of companies, such as LinkedIn, VMWare, Slack, Redfin among many others. Samza provides leading support for large-scale stateful stream processing with:

* First class support for local state (with RocksDB store). This allows a stateful application to scale up to 1.1 Million events/sec on a single machine with SSD.

* Support for incremental checkpointing of state instead of full snapshots. This enables Samza to scale to applications with very large state.

* A fully asynchronous programming model that makes parallelizing remote calls efficient and effortless.

* High level API for expressing complex stream processing pipelines in a few lines of code.

* Beam Samza Runner that marries Beam’s best in class support for EventTime based windowed processing and sophisticated triggering with Samza’s stable and scalable stateful processing model. 

* A fully pluggable model for input sources (e.g. Kafka, Kinesis, DynamoDB streams etc.) and output systems (HDFS, Kafka, ElastiCache etc.).

* A Table API that provides a common abstraction for accessing remote or local databases and allowing developers are able to "join" an input event stream with such a Table.

* Flexible deployment model for running the applications in any hosting environment and with cluster managers other than YARN.

* Features like canaries, upgrades and rollbacks that support extremely large deployments with minimal downtime.

###  **New Features, Upgrades and Bug Fixes**
This release brings the following features, upgrades, and capabilities:

  * We have created a new Samza Stream Processing [video series](https://www.youtube.com/playlist?list=PLZDyxA22zzGyNgtBMUIXAgIaO5Ok3PR-x) 
   on Youtube

  * New and improved documentation, 
    code snippets, and examples for using the latest version of 
    Samza with Apache Beam (Code samples are here: [https://github.com/apache/samza-beam-examples](https://github.com/apache/samza-beam-examples))

### **API enhancements and simplifications**

[SAMZA-1981](https://issues.apache.org/jira/browse/SAMZA-1981): Consolidate table descriptors to samza-api.

[SAMZA-1998](https://issues.apache.org/jira/browse/SAMZA-1998): Table API refactoring.

[SAMZA-1980](https://issues.apache.org/jira/browse/SAMZA-1980): Rename LocalStoreBackedTable to LocalTable.

[SAMZA-2043](https://issues.apache.org/jira/browse/SAMZA-2043): Consolidate ReadableTable and ReadWriteTable.

[SAMZA-2012](https://issues.apache.org/jira/browse/SAMZA-2012): Add API for wiring an external context through to application processing.

[SAMZA-2026](https://issues.apache.org/jira/browse/SAMZA-2026): Refactor remote table API to separate retry policy settings.

[SAMZA-2041](https://issues.apache.org/jira/browse/SAMZA-2041): Add system descriptors for HDFS and Kinesis.

[SAMZA-2081](https://issues.apache.org/jira/browse/SAMZA-2081): Samza SQL: Type system for Samza SQL.

[SAMZA-2106](https://issues.apache.org/jira/browse/SAMZA-2106): Samza App & Job Config Refactor.

### **State Store Restoration**

[SAMZA-2018](https://issues.apache.org/jira/browse/SAMZA-2018): State restore improvements using RocksDB writebatch API.

### **Standalone Improvements**

[SAMZA-1973](https://issues.apache.org/jira/browse/SAMZA-1973): Unify the TaskNameGrouper interface for yarn and standalone.

[SAMZA-1952](https://issues.apache.org/jira/browse/SAMZA-1952): StreamPartitionCountMonitor for standalone.

### **Other Upgrades and Bug-fixes**

[SAMZA-1638](https://issues.apache.org/jira/browse/SAMZA-1638): Recreate SystemProducer on KafkaCheckpointManager.writeCheckpoint failure.

[SAMZA-1946](https://issues.apache.org/jira/browse/SAMZA-1946): Problem with Race between TimerListener initialization and timers fired from init().

[SAMZA-2004](https://issues.apache.org/jira/browse/SAMZA-2004): Add ability to disable table metrics.

[SAMZA-2013](https://issues.apache.org/jira/browse/SAMZA-2013): Account for cycles in graph traversal within Execution Planner.

[SAMZA-2015](https://issues.apache.org/jira/browse/SAMZA-2015): Refactor timer handling in tables to be consistent with stores.

[SAMZA-2072](https://issues.apache.org/jira/browse/SAMZA-2072): Update guava to 23.0.

[SAMZA-2090](https://issues.apache.org/jira/browse/SAMZA-2090): Fix flush behavior for remote and hybrid tables.

[SAMZA-2108:](https://issues.apache.org/jira/browse/SAMZA-2108) Check for host affinity config before resolving preferred host matching.

[SAMZA-2109](https://issues.apache.org/jira/browse/SAMZA-2109): Reduce default-buffer sizes for per-partition queues.

[SAMZA-2118](https://issues.apache.org/jira/browse/SAMZA-2118): Improve the shutdown sequence of AsyncRunLoop.

[SAMZA-2119](https://issues.apache.org/jira/browse/SAMZA-2119): Upgrading yarn-client version to 2.7.1.

[SAMZA-2122](https://issues.apache.org/jira/browse/SAMZA-2122): Fix the task caught-up logic which doesn't handle no incoming messages

The complete list of resolved Jira tickets for this release is found [here](https://issues.apache.org/jira/issues/?jql=project%20%3D%20SAMZA%20AND%20resolution%20%20%3D%20Fixed%20%20AND%20(fixVersion%20%3E%3D%201.1%20)%20ORDER%20BY%20createdDate%20%20DESC).
 
### **Upgrading your application to Apache Samza 1.1.0**
 
 Thank you on your decision to upgrade to Samza 1.1.0!
 
#### **API Updates**
 
 The following imports for Table API have been updated:
 
 * Rename the import *org.apache.samza.storage.kv.descriptors.BaseLocalStoreBackedTableDescriptor* to *org.apache.samza.storage.kv.descriptors.BaseLocalTableDescriptor*
 
 * Rename the import *org.apache.samza.table.remote.descriptors.RemoteTableDescriptor* to *org.apache.samza.table.descriptors.RemoteTableDescriptor*
 
 * Rename the import *org.apache.samza.table.caching.descriptors.CachingTableDescriptor* to *org.apache.samza.table.descriptors.CachingTableDescriptor*
 
#### **Configurations Updates**
 
 The job.name and job.id configs are now deprecated in favor of app.name and app.id configs respectively.


A source download of Samza 1.1.0 is available [here](https://dist.apache.org/repos/dist/release/samza/1.1.0/), and is also available in Apache’s Maven repository. Samza’s download [page](https://samza.apache.org/startup/download/) for details and Samza’s feature preview for new features. 

## **Community Developments**
A [Stream Processing with Apache Kafka & Apache Samza meetup/symposium](https://www.meetup.com/Stream-Processing-Meetup-LinkedIn/) that was held on March 20th which had following presentation for Samza:

* Apache Samza 1.0: Recent Advances and our plans for future in Stream Processing

##**Contribute**

It’s a great time to get involved. You can start by reviewing the [tutorials](http://samza.apache.org/startup/preview/#try-it-out), signing up for the [mailing list](http://samza.apache.org/community/mailing-lists.html), and grabbing some [newbie JIRAs](https://issues.apache.org/jira/issues/?jql=project%20%3D%20SAMZA%20AND%20labels%20%3D%20newbie%20AND%20status%20%3D%20Open). 

I’d like to close by thanking everyone who’s been involved in the project. It’s been a great experience to be involved in this community, and I look forward to its continued growth.

