/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.interceptor;

import com.google.common.net.HostAndPort;
import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.proxy.grpc.constant.AttributeKeys;
import org.apache.rocketmq.proxy.grpc.interceptor.InterceptorConstants;

public class HeaderInterceptor
implements ServerInterceptor {
    public <R, W> ServerCall.Listener<R> interceptCall(ServerCall<R, W> call, Metadata headers, ServerCallHandler<R, W> next) {
        String remoteAddress = this.getProxyProtocolAddress(call.getAttributes());
        if (StringUtils.isBlank((CharSequence)remoteAddress)) {
            SocketAddress remoteSocketAddress = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            remoteAddress = this.parseSocketAddress(remoteSocketAddress);
        }
        headers.put(InterceptorConstants.REMOTE_ADDRESS, (Object)remoteAddress);
        SocketAddress localSocketAddress = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
        String localAddress = this.parseSocketAddress(localSocketAddress);
        headers.put(InterceptorConstants.LOCAL_ADDRESS, (Object)localAddress);
        for (Attributes.Key key : call.getAttributes().keys()) {
            if (!StringUtils.startsWith((CharSequence)key.toString(), (CharSequence)"proxy_protocol_")) continue;
            Metadata.Key headerKey = Metadata.Key.of((String)key.toString(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            String headerValue = String.valueOf(call.getAttributes().get(key));
            headers.put(headerKey, (Object)headerValue);
        }
        return next.startCall(call, headers);
    }

    private String parseSocketAddress(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return HostAndPort.fromParts((String)inetSocketAddress.getAddress().getHostAddress(), (int)inetSocketAddress.getPort()).toString();
        }
        return "";
    }

    private String getProxyProtocolAddress(Attributes attributes) {
        String proxyProtocolAddr = (String)attributes.get(AttributeKeys.PROXY_PROTOCOL_ADDR);
        String proxyProtocolPort = (String)attributes.get(AttributeKeys.PROXY_PROTOCOL_PORT);
        if (StringUtils.isBlank((CharSequence)proxyProtocolAddr) || StringUtils.isBlank((CharSequence)proxyProtocolPort)) {
            return null;
        }
        return proxyProtocolAddr + ":" + proxyProtocolPort;
    }
}

