/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;

public class CERTConverter {
    public static Certificate parseRecord(CERTRecord r) {
        int type = r.getCertType();
        byte[] data = r.getCert();
        try {
            Certificate cert;
            switch (type) {
                case 1: {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream bs = new ByteArrayInputStream(data);
                    cert = cf.generateCertificate(bs);
                    break;
                }
                default: {
                    return null;
                }
            }
            return cert;
        }
        catch (CertificateException e) {
            if (Options.check("verboseexceptions")) {
                System.err.println("Cert parse exception:" + e);
            }
            return null;
        }
    }

    public static CERTRecord buildRecord(Name name, int dclass, long ttl, Certificate cert, int tag, int alg) {
        try {
            if (!(cert instanceof X509Certificate)) {
                return null;
            }
            int type = 1;
            byte[] data = cert.getEncoded();
            return new CERTRecord(name, dclass, ttl, type, tag, alg, data);
        }
        catch (CertificateException e) {
            if (Options.check("verboseexceptions")) {
                System.err.println("Cert build exception:" + e);
            }
            return null;
        }
    }

    public static CERTRecord buildRecord(Name name, int dclass, long ttl, Certificate cert) {
        return CERTConverter.buildRecord(name, dclass, ttl, cert, 0, 0);
    }
}

