/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.protocol;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.core.base.handler.IQHandler;
import org.apache.vysper.xmpp.modules.core.base.handler.MessageHandler;
import org.apache.vysper.xmpp.modules.core.base.handler.RelayingIQHandler;
import org.apache.vysper.xmpp.modules.core.base.handler.StreamStartHandler;
import org.apache.vysper.xmpp.modules.core.base.handler.XMLPrologHandler;
import org.apache.vysper.xmpp.modules.core.im.handler.PresenceHandler;
import org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback.DbResultHandler;
import org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback.DbVerifyHandler;
import org.apache.vysper.xmpp.protocol.AbstractStanzaHandlerLookup;
import org.apache.vysper.xmpp.protocol.ServiceUnavailableStanzaErrorHandler;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class StanzaHandlerLookup
extends AbstractStanzaHandlerLookup {
    private IQHandler iqHandler = new RelayingIQHandler();
    private MessageHandler messageHandler = new MessageHandler();
    private PresenceHandler presenceHandler = new PresenceHandler();
    private static final ServiceUnavailableStanzaErrorHandler SERVICE_UNAVAILABLE_STANZA_ERROR_HANDLER = new ServiceUnavailableStanzaErrorHandler();
    protected ServerRuntimeContext serverRuntimeContext;

    public StanzaHandlerLookup(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public StanzaHandler getHandler(Stanza stanza) {
        if (stanza == null) {
            return null;
        }
        StanzaHandler stanzaHandler = this.getHandlerForElement(stanza, stanza);
        if (stanzaHandler != null) {
            return stanzaHandler;
        }
        String name = stanza.getName();
        if ("xml".equals(name)) {
            return new XMLPrologHandler();
        }
        if ("stream".equals(name)) {
            return new StreamStartHandler();
        }
        if ("verify".equals(name)) {
            return new DbVerifyHandler();
        }
        if ("result".equals(name)) {
            return new DbResultHandler();
        }
        if (this.iqHandler.verify(stanza)) {
            return this.getIQHandler(stanza);
        }
        if (this.messageHandler.verify(stanza)) {
            return this.getMessageHandler(stanza);
        }
        if (this.presenceHandler.verify(stanza)) {
            return this.getPresenceHandler(stanza);
        }
        if (XMPPCoreStanza.getWrapper(stanza) != null) {
            return SERVICE_UNAVAILABLE_STANZA_ERROR_HANDLER;
        }
        return null;
    }

    private StanzaHandler getPresenceHandler(Stanza stanza) {
        return this.presenceHandler;
    }

    private StanzaHandler getMessageHandler(Stanza stanza) {
        return this.messageHandler;
    }

    private StanzaHandler getIQHandler(Stanza stanza) {
        StanzaHandler handlerForElement = null;
        Entity to = stanza.getTo();
        Entity serverEntity = this.serverRuntimeContext == null ? null : this.serverRuntimeContext.getServerEnitity();
        boolean isAddressedToServerOrComponent = to == null || !to.isNodeSet() && !to.isResourceSet();
        boolean isAddressedToComponent = to != null && isAddressedToServerOrComponent && serverEntity != null && !serverEntity.equals(to);
        boolean isAddressedToServer = to == null || isAddressedToServerOrComponent && !isAddressedToComponent;
        StanzaHandler resolvedHandler = null;
        if (stanza.getVerifier().subElementsPresentExact(1)) {
            XMLElement firstInnerElement = stanza.getFirstInnerElement();
            handlerForElement = this.getHandlerForElement(stanza, firstInnerElement);
            if (handlerForElement != null) {
                resolvedHandler = handlerForElement;
            }
            if (resolvedHandler == null && isAddressedToServer && XMPPCoreStanza.getWrapper(stanza) != null) {
                resolvedHandler = SERVICE_UNAVAILABLE_STANZA_ERROR_HANDLER;
            }
        }
        if (resolvedHandler == null) {
            resolvedHandler = this.iqHandler;
        }
        return resolvedHandler;
    }
}

