/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.delivery.inbound;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.delivery.OfflineStanzaReceiver;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.DeliveryFailureStrategy;
import org.apache.vysper.xmpp.delivery.inbound.RelayResult;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.s2s.XMPPServerConnector;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveringExternalInboundStanzaRelay
implements StanzaRelay {
    final Logger logger = LoggerFactory.getLogger(DeliveringExternalInboundStanzaRelay.class);
    protected ExecutorService executor;
    protected OfflineStanzaReceiver offlineStanzaReceiver = null;
    protected ServerRuntimeContext serverRuntimeContext = null;

    public DeliveringExternalInboundStanzaRelay() {
        int coreThreadCount = 10;
        int maxThreadCount = 20;
        int threadTimeoutSeconds = 120000;
        this.executor = new ThreadPoolExecutor(coreThreadCount, maxThreadCount, threadTimeoutSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public DeliveringExternalInboundStanzaRelay(ExecutorService executor) {
        this.executor = executor;
    }

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.serverRuntimeContext = serverRuntimeContext;
    }

    public void relay(Entity receiver, Stanza stanza, DeliveryFailureStrategy deliveryFailureStrategy) throws DeliveryException {
        XMPPCoreStanza coreStanza = XMPPCoreStanza.getWrapper(stanza = StanzaBuilder.rewriteNamespace(stanza, "jabber:client", "jabber:server"));
        if (coreStanza != null) {
            Future<RelayResult> resultFuture = this.executor.submit(new OutboundRelayCallable(coreStanza, deliveryFailureStrategy));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OutboundRelayCallable
    implements Callable<RelayResult> {
        private XMPPCoreStanza stanza;
        private DeliveryFailureStrategy deliveryFailureStrategy;

        OutboundRelayCallable(XMPPCoreStanza stanza, DeliveryFailureStrategy deliveryFailureStrategy) {
            this.stanza = stanza;
            this.deliveryFailureStrategy = deliveryFailureStrategy;
        }

        @Override
        public RelayResult call() {
            RelayResult relayResult = this.deliver();
            if (relayResult == null || !relayResult.hasProcessingErrors()) {
                return relayResult;
            }
            return this.runFailureStrategy(relayResult);
        }

        private RelayResult runFailureStrategy(RelayResult relayResult) {
            if (this.deliveryFailureStrategy != null) {
                try {
                    this.deliveryFailureStrategy.process(this.stanza, relayResult.getProcessingErrors());
                }
                catch (DeliveryException e) {
                    return new RelayResult(e);
                }
                catch (RuntimeException e) {
                    return new RelayResult(new DeliveryException(e));
                }
            }
            return relayResult;
        }

        protected RelayResult deliver() {
            try {
                RelayResult relayResult = new RelayResult();
                XMPPServerConnector connector = DeliveringExternalInboundStanzaRelay.this.serverRuntimeContext.getServerConnectorRegistry().connect(EntityImpl.parseUnchecked(this.stanza.getTo().getDomain()));
                connector.write(this.stanza);
                return relayResult;
            }
            catch (DeliveryException e) {
                return new RelayResult(e);
            }
        }
    }
}

