/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.SignerOutputStream;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.w3c.dom.Element;

public final class DOMDSASignatureMethod
extends DOMSignatureMethod {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private Signature signature;

    public DOMDSASignatureMethod(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2000/09/xmldsig#dsa-sha1", algorithmParameterSpec);
    }

    public DOMDSASignatureMethod(Element element) throws MarshalException {
        super(element);
    }

    protected void checkParams(SignatureMethodParameterSpec signatureMethodParameterSpec) throws InvalidAlgorithmParameterException {
        if (signatureMethodParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for DSA signature algorithm");
        }
    }

    protected SignatureMethodParameterSpec unmarshalParams(Element element) throws MarshalException {
        throw new MarshalException("no parameters should be specified for DSA signature algorithm");
    }

    protected void marshalParams(Element element, String string) throws MarshalException {
        throw new MarshalException("no parameters should be specified for DSA signature algorithm");
    }

    protected boolean paramsEqual(AlgorithmParameterSpec algorithmParameterSpec) {
        return this.getParameterSpec() == algorithmParameterSpec;
    }

    public boolean verify(Key key, DOMSignedInfo dOMSignedInfo, byte[] byArray, XMLValidateContext xMLValidateContext) throws InvalidKeyException, SignatureException, XMLSignatureException {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (byArray == null) {
            throw new NullPointerException("signature cannot be null");
        }
        if (dOMSignedInfo == null) {
            throw new NullPointerException("signedInfo cannot be null");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withDSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SignatureException("SHA1withDSA Signature not found");
            }
        }
        try {
            if (!(key instanceof PublicKey)) {
                throw new InvalidKeyException("key must be PublicKey");
            }
            this.signature.initVerify((PublicKey)key);
            dOMSignedInfo.canonicalize(xMLValidateContext, new SignerOutputStream(this.signature));
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "verifying with key: " + key);
            }
            return this.signature.verify(DOMDSASignatureMethod.convertXMLDSIGtoASN1(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public byte[] sign(Key key, DOMSignedInfo dOMSignedInfo, XMLSignContext xMLSignContext) throws InvalidKeyException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withDSA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException("SHA1withDSA Signature not found");
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Signing with key: " + key);
        }
        this.signature.initSign((PrivateKey)key);
        dOMSignedInfo.canonicalize(xMLSignContext, new SignerOutputStream(this.signature));
        try {
            return DOMDSASignatureMethod.convertASN1toXMLDSIG(this.signature.sign());
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException.getMessage());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private static byte[] convertASN1toXMLDSIG(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = n3 = byArray[3]; n4 > 0 && byArray[4 + n3 - n4] == 0; --n4) {
        }
        for (n2 = n = byArray[5 + n3]; n2 > 0 && byArray[6 + n3 + n - n2] == 0; --n2) {
        }
        if (byArray[0] != 48 || byArray[1] != byArray.length - 2 || byArray[2] != 2 || n4 > 20 || byArray[4 + n3] != 2 || n2 > 20) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] byArray2 = new byte[40];
        System.arraycopy(byArray, 4 + n3 - n4, byArray2, 20 - n4, n4);
        System.arraycopy(byArray, 6 + n3 + n - n2, byArray2, 40 - n2, n2);
        return byArray2;
    }

    private static byte[] convertXMLDSIGtoASN1(byte[] byArray) throws IOException {
        int n;
        int n2;
        if (byArray.length != 40) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        for (n2 = 20; n2 > 0 && byArray[20 - n2] == 0; --n2) {
        }
        int n3 = n2;
        if (byArray[20 - n2] < 0) {
            ++n3;
        }
        for (n = 20; n > 0 && byArray[40 - n] == 0; --n) {
        }
        int n4 = n;
        if (byArray[40 - n] < 0) {
            ++n4;
        }
        byte[] byArray2 = new byte[6 + n3 + n4];
        byArray2[0] = 48;
        byArray2[1] = (byte)(4 + n3 + n4);
        byArray2[2] = 2;
        byArray2[3] = (byte)n3;
        System.arraycopy(byArray, 20 - n2, byArray2, 4 + n3 - n2, n2);
        byArray2[4 + n3] = 2;
        byArray2[5 + n3] = (byte)n4;
        System.arraycopy(byArray, 40 - n, byArray2, 6 + n3 + n4 - n, n);
        return byArray2;
    }
}

