/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.cloud.autoscaling.TriggerListener;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.core.SolrResourceLoader;

public abstract class TriggerListenerBase
implements TriggerListener {
    protected AutoScalingConfig.TriggerListenerConfig config;
    protected SolrCloudManager cloudManager;
    protected SolrResourceLoader loader;
    protected boolean enabled;
    protected final Set<String> validProperties = new HashSet<String>();
    protected final Set<String> requiredProperties = new HashSet<String>();
    protected final Set<String> validPropertyPrefixes = new HashSet<String>();

    protected TriggerListenerBase() {
        TriggerUtils.requiredProperties(this.requiredProperties, this.validProperties, "trigger");
        TriggerUtils.validProperties(this.validProperties, "name", "class", "stage", "beforeAction", "afterAction", "enabled");
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, AutoScalingConfig.TriggerListenerConfig config) throws TriggerValidationException {
        this.loader = loader;
        this.cloudManager = cloudManager;
        this.config = config;
        this.enabled = Boolean.parseBoolean(String.valueOf(config.properties.getOrDefault("enabled", true)));
        HashMap<String, String> results = new HashMap<String, String>();
        HashMap<String, Object> propsToCheck = new HashMap<String, Object>(config.properties);
        propsToCheck.keySet().removeIf(k -> this.validPropertyPrefixes.stream().anyMatch(p -> k.startsWith((String)p)));
        TriggerUtils.checkProperties(propsToCheck, results, this.requiredProperties, this.validProperties);
        if (!results.isEmpty()) {
            throw new TriggerValidationException(config.name, results);
        }
    }

    @Override
    public AutoScalingConfig.TriggerListenerConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void close() throws IOException {
    }
}

