/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import com.carrotsearch.ant.tasks.junit4.BalancersList;
import com.carrotsearch.ant.tasks.junit4.DiagnosticsListener;
import com.carrotsearch.ant.tasks.junit4.Duration;
import com.carrotsearch.ant.tasks.junit4.ForkedJvmInfo;
import com.carrotsearch.ant.tasks.junit4.JUnit4$1;
import com.carrotsearch.ant.tasks.junit4.JUnit4$2;
import com.carrotsearch.ant.tasks.junit4.JUnit4$3;
import com.carrotsearch.ant.tasks.junit4.JUnit4$4;
import com.carrotsearch.ant.tasks.junit4.JUnit4$5;
import com.carrotsearch.ant.tasks.junit4.JUnit4$6;
import com.carrotsearch.ant.tasks.junit4.JUnit4$ExtendedPropertySet;
import com.carrotsearch.ant.tasks.junit4.JUnit4$ExtendedVariable;
import com.carrotsearch.ant.tasks.junit4.JUnit4$JvmOutputAction;
import com.carrotsearch.ant.tasks.junit4.JUnit4$NoTestsAction;
import com.carrotsearch.ant.tasks.junit4.ListenersList;
import com.carrotsearch.ant.tasks.junit4.LocalForkedJvmStreamHandler;
import com.carrotsearch.ant.tasks.junit4.NonEmptyWorkDirectoryAction;
import com.carrotsearch.ant.tasks.junit4.RunListenerList;
import com.carrotsearch.ant.tasks.junit4.SuiteBalancer;
import com.carrotsearch.ant.tasks.junit4.SuiteBalancer$Assignment;
import com.carrotsearch.ant.tasks.junit4.TailInputStream;
import com.carrotsearch.ant.tasks.junit4.TestClass;
import com.carrotsearch.ant.tasks.junit4.TestsCollection;
import com.carrotsearch.ant.tasks.junit4.TestsSummary;
import com.carrotsearch.ant.tasks.junit4.TestsSummaryEventListener;
import com.carrotsearch.ant.tasks.junit4.balancers.RoundRobinBalancer;
import com.carrotsearch.ant.tasks.junit4.balancers.SuiteHint;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ClassGlobFilter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.FilterExpressionParser;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.FilterExpressionParser$Node;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.MethodGlobFilter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.TeeOutputStream;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.MoreObjects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closeables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.FileWriteMode;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ClassReader;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedQuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedStartEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatingListener;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.JvmOutputEvent;
import com.carrotsearch.ant.tasks.junit4.forked.ForkedMain;
import com.carrotsearch.ant.tasks.junit4.forked.ForkedMainSafe;
import com.carrotsearch.ant.tasks.junit4.listeners.AggregatedEventListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.util.LoaderUtils;
import org.junit.runner.Description;

public class JUnit4
extends Task {
    private static String[] WELCOME_MESSAGES = new String[]{"hello!", "hi!", "g'day!", "\u00a1Hola!", "jolly good day!", "aloha!", "cze\u015b\u0107!", "\u0645\u0631\u062d\u0628\u0627!", "kaixo!", "\u041f\u0440\u0438\u0432\u0435\u0442!", "\u4f60\u597d!", "ahoj!", "salut!", "hallo!", "\u05e9\u05dc\u05d5\u05dd!", "\u0928\u092e\u0938\u094d\u0924\u0947!", "\u140a\u1403!", "ciao!", "\u4eca\u65e5\u306f!", "ol\u00e1!"};
    public static final String ANTLIB_RESOURCE_NAME = "com/carrotsearch/junit4/antlib.xml";
    public static final Object PARALLELISM_AUTO = "auto";
    public static final String PARALLELISM_MAX = "max";
    public static final boolean DEFAULT_SHUFFLE_ON_FORKED_JVM = true;
    public static final String DEFAULT_PARALLELISM = "1";
    public static final boolean DEFAULT_PRINT_SUMMARY = true;
    public static final boolean DEFAULT_HALT_ON_FAILURE = true;
    public static final boolean DEFAULT_ISOLATE_WORKING_DIRECTORIES = true;
    public static final NonEmptyWorkDirectoryAction DEFAULT_NON_EMPTY_WORKDIR_ACTION = NonEmptyWorkDirectoryAction.FAIL;
    public static final float DEFAULT_DYNAMIC_ASSIGNMENT_RATIO = 0.25f;
    public static final boolean DEFAULT_SYSOUTS = false;
    public static final boolean DEFAULT_DEBUGSTREAM = false;
    public static final boolean DEFAULT_UNIQUE_SUITE_NAME = true;
    private static final String CHILDVM_SYSPROP_CWD = "junit4.childvm.cwd";
    private static final String SYSPROP_TEMPDIR = "junit4.tempDir";
    public EnumSet jvmOutputAction = EnumSet.of(JUnit4$JvmOutputAction.LISTENERS, JUnit4$JvmOutputAction.WARN);
    private boolean sysouts = false;
    private boolean debugStream = false;
    private CommandlineJava forkedJvmCommandLine = new CommandlineJava();
    private boolean newEnvironment;
    private boolean uniqueSuiteNames = true;
    private Environment env = new Environment();
    private Path dir;
    private final Resources resources;
    private boolean haltOnFailure = true;
    private boolean printSummary = true;
    private String failureProperty;
    private Path tempDir;
    private List listeners = new ArrayList();
    private List runListeners = new ArrayList();
    private List balancers = new ArrayList();
    private AntClassLoader testsClassLoader;
    private String parallelism = "1";
    private boolean leaveTemporary;
    private List temporaryFiles = Collections.synchronizedList(new ArrayList());
    private String random;
    private boolean isolateWorkingDirectories = true;
    private NonEmptyWorkDirectoryAction nonEmptyWorkDirAction = DEFAULT_NON_EMPTY_WORKDIR_ACTION;
    private org.apache.tools.ant.types.Path classpath;
    private org.apache.tools.ant.types.Path bootclasspath;
    private float dynamicAssignmentRatio = 0.25f;
    private boolean shuffleOnForkedJvm = true;
    private long heartbeat;
    private JUnit4$NoTestsAction ifNoTests = JUnit4$NoTestsAction.IGNORE;
    private String statsPropertyPrefix;

    public JUnit4() {
        this.resources = new Resources();
    }

    public void setJvmOutputAction(String string) {
        EnumSet<JUnit4$JvmOutputAction> enumSet = EnumSet.noneOf(JUnit4$JvmOutputAction.class);
        for (String string2 : string.split("[\\,\\ ]+")) {
            string2 = string2.trim().toUpperCase(Locale.ROOT);
            enumSet.add(JUnit4$JvmOutputAction.valueOf(string2));
        }
        this.jvmOutputAction = enumSet;
    }

    public void setSysouts(boolean bl) {
        this.sysouts = bl;
    }

    public void setDebugStream(boolean bl) {
        this.debugStream = bl;
    }

    public void setUniqueSuiteNames(boolean bl) {
        this.uniqueSuiteNames = bl;
    }

    public boolean isUniqueSuiteNames() {
        return this.uniqueSuiteNames;
    }

    public void setDynamicAssignmentRatio(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Dynamic assignment ratio must be between 0 (only static assignments) to 1 (fully dynamic assignments).");
        }
        this.dynamicAssignmentRatio = f;
    }

    public void setParallelism(String string) {
        this.parallelism = string;
    }

    public void setFailureProperty(String string) {
        this.failureProperty = string;
    }

    public void setNewEnvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public void setSeed(String string) {
        if (!Strings.isNullOrEmpty(this.getProject().getUserProperty(SysGlobals.SYSPROP_RANDOM_SEED()))) {
            String string2 = this.getProject().getUserProperty(SysGlobals.SYSPROP_RANDOM_SEED());
            if (!string2.equals(string)) {
                this.log("Ignoring seed attribute because it is overridden by user properties.", 1);
            }
        } else if (!Strings.isNullOrEmpty(string)) {
            this.random = string;
        }
    }

    public void setPrefix(String string) {
        if (!Strings.isNullOrEmpty(this.getProject().getUserProperty(SysGlobals.SYSPROP_PREFIX()))) {
            this.log("Ignoring prefix attribute because it is overridden by user properties.", 1);
        } else {
            SysGlobals.initializeWith(string);
        }
    }

    public String getSeed() {
        return this.random;
    }

    @Deprecated
    public void setShuffleOnSlave(boolean bl) {
        this.setShuffleOnForkedJvm(bl);
    }

    public void setShuffleOnForkedJvm(boolean bl) {
        this.shuffleOnForkedJvm = bl;
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.resources.setProject(project);
        this.classpath = new org.apache.tools.ant.types.Path(this.getProject());
        this.bootclasspath = new org.apache.tools.ant.types.Path(this.getProject());
    }

    public void setPrintSummary(boolean bl) {
        this.printSummary = bl;
    }

    public void setHaltOnFailure(boolean bl) {
        this.haltOnFailure = bl;
    }

    public void setMaxmemory(String string) {
        if (!Strings.isNullOrEmpty(string)) {
            this.getCommandline().setMaxmemory(string);
        }
    }

    public void setLeaveTemporary(boolean bl) {
        this.leaveTemporary = bl;
    }

    public Commandline.Argument createJvmarg() {
        return this.getCommandline().createVmArgument();
    }

    public void setDir(File file) {
        this.dir = file.toPath();
    }

    public void setTempDir(File file) {
        this.tempDir = file.toPath();
    }

    public void setIfNoTests(String string) {
        try {
            this.ifNoTests = JUnit4$NoTestsAction.valueOf(string.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BuildException("Invalid value (one of " + Arrays.toString((Object[])JUnit4$NoTestsAction.values()) + " accepted): " + string);
        }
    }

    public void addConfiguredSysproperty(JUnit4$ExtendedVariable jUnit4$ExtendedVariable) {
        if (!jUnit4$ExtendedVariable.shouldIgnore()) {
            this.getCommandline().addSysproperty((Environment.Variable)jUnit4$ExtendedVariable);
        }
    }

    public void addConfiguredSyspropertyset(JUnit4$ExtendedPropertySet jUnit4$ExtendedPropertySet) {
        this.getCommandline().addSyspropertyset((PropertySet)jUnit4$ExtendedPropertySet);
    }

    public void setJvm(String string) {
        if (!Strings.isNullOrEmpty(string)) {
            this.getCommandline().setVm(string);
        }
    }

    public void setIsolateWorkingDirectories(boolean bl) {
        this.isolateWorkingDirectories = bl;
    }

    public void setOnNonEmptyWorkDirectory(String string) {
        try {
            this.nonEmptyWorkDirAction = NonEmptyWorkDirectoryAction.valueOf(string.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("OnNonEmptyWorkDirectory accepts any of: " + Arrays.toString((Object[])NonEmptyWorkDirectoryAction.values()) + ", value is not valid: " + string);
        }
    }

    public void addEnv(JUnit4$ExtendedVariable jUnit4$ExtendedVariable) {
        this.env.addVariable((Environment.Variable)jUnit4$ExtendedVariable);
    }

    public void addFileSet(FileSet fileSet) {
        this.add((ResourceCollection)fileSet);
        if (fileSet.getProject() == null) {
            fileSet.setProject(this.getProject());
        }
    }

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    public ListenersList createListeners() {
        return new ListenersList(this.listeners);
    }

    public RunListenerList createRunListeners() {
        return new RunListenerList(this.runListeners);
    }

    public void addAssertions(Assertions assertions) {
        if (this.getCommandline().getAssertions() != null) {
            throw new BuildException("Only one assertion declaration is allowed");
        }
        this.getCommandline().setAssertions(assertions);
    }

    public BalancersList createBalancers() {
        return new BalancersList(this.balancers);
    }

    public org.apache.tools.ant.types.Path createClasspath() {
        return this.classpath.createPath();
    }

    public org.apache.tools.ant.types.Path createBootclasspath() {
        return this.bootclasspath.createPath();
    }

    public void setFork(boolean bl) {
        this.warnUnsupported("fork");
    }

    public void setForkmode(String string) {
        this.warnUnsupported("forkmode");
    }

    public void setHaltOnError(boolean bl) {
        this.warnUnsupported("haltonerror");
    }

    public void setFiltertrace(boolean bl) {
        this.warnUnsupported("filtertrace");
        this.log("Hint: report listeners have stack filtering options.", 1);
    }

    public void setTimeout(String string) {
        this.warnUnsupported("timeout");
    }

    public void setIncludeantruntime(String string) {
        this.warnUnsupported("includeantruntime");
    }

    public void setShowoutput(String string) {
        this.warnUnsupported("showoutput");
    }

    public void setOutputtoformatters(String string) {
        this.warnUnsupported("outputtoformatters");
    }

    public void setReloading(String string) {
        this.warnUnsupported("reloading");
    }

    public void setClonevm(String string) {
        this.warnUnsupported("clonevm");
    }

    public void setErrorproperty(String string) {
        this.warnUnsupported("errorproperty");
    }

    public void setLogfailedtests(String string) {
        this.warnUnsupported("logfailedtests");
    }

    public void setEnableTestListenerEvents(String string) {
        this.warnUnsupported("enableTestListenerEvents");
    }

    public Object createFormatter() {
        throw new BuildException("<formatter> elements are not supported by <junit4>. Refer to the documentation about listeners and reports.");
    }

    public Object createTest() {
        throw new BuildException("<test> elements are not supported by <junit4>. Use regular ANT resource collections to point at individual tests or their groups.");
    }

    public Object createBatchtest() {
        throw new BuildException("<batchtest> elements are not supported by <junit4>. Use regular ANT resource collections to point at individual tests or their groups.");
    }

    private void warnUnsupported(String string) {
        this.log("The '" + string + "' attribute is not supported by <junit4>.", 1);
    }

    public void setHeartbeat(long l) {
        this.heartbeat = l;
    }

    public void setStatsPropertyPrefix(String string) {
        this.statsPropertyPrefix = string;
    }

    public void execute() {
        int n;
        TestsCollection testsCollection;
        this.validateJUnit4();
        this.validateArguments();
        if (this.random == null) {
            this.random = (String)MoreObjects.firstNonNull(Strings.emptyToNull(this.getProject().getProperty(SysGlobals.SYSPROP_RANDOM_SEED())), SeedUtils.formatSeed(new Random().nextLong()));
        }
        this.mainSeed();
        this.log("<JUnit4> says " + (String)RandomPicks.randomFrom(new Random(this.mainSeed()), WELCOME_MESSAGES) + " Main seed: " + this.getSeed(), 2);
        this.createJvmarg().setValue("-D" + SysGlobals.SYSPROP_PREFIX() + "=" + SysGlobals.CURRENT_PREFIX());
        this.createJvmarg().setValue("-D" + SysGlobals.SYSPROP_RANDOM_SEED() + "=" + this.random);
        this.classpath = this.resolveFiles(this.classpath);
        this.bootclasspath = this.resolveFiles(this.bootclasspath);
        this.getCommandline().createClasspath(this.getProject()).add(this.classpath);
        this.getCommandline().createBootclasspath(this.getProject()).add(this.bootclasspath);
        this.testsClassLoader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.getCommandline().getClasspath(), true);
        String string = Strings.emptyToNull(this.getProject().getProperty(SysGlobals.SYSPROP_TESTMETHOD()));
        if (string != null) {
            testsCollection = new Environment.Variable();
            testsCollection.setKey(SysGlobals.SYSPROP_TESTMETHOD());
            testsCollection.setValue(string);
            this.getCommandline().addSysproperty((Environment.Variable)testsCollection);
        }
        testsCollection = this.processTestResources();
        EventBus eventBus = new EventBus("aggregated");
        TestsSummaryEventListener testsSummaryEventListener = new TestsSummaryEventListener();
        eventBus.register(testsSummaryEventListener);
        for (Object object : this.listeners) {
            if (object instanceof ProjectComponent) {
                ((ProjectComponent)object).setProject(this.getProject());
            }
            if (object instanceof AggregatedEventListener) {
                ((AggregatedEventListener)object).setOuter(this);
            }
            eventBus.register(object);
        }
        if (testsCollection.testClasses.isEmpty()) {
            eventBus.post(new AggregatedQuitEvent());
        } else {
            Object object;
            Object object2;
            long l = System.currentTimeMillis();
            if (this.uniqueSuiteNames) {
                testsCollection.onlyUniqueSuiteNames();
            }
            int n2 = this.determineForkedJvmCount(testsCollection);
            ArrayList<ForkedJvmInfo> arrayList = new ArrayList<ForkedJvmInfo>();
            for (int i = 0; i < n2; ++i) {
                object2 = new ForkedJvmInfo(i, n2);
                arrayList.add((ForkedJvmInfo)object2);
            }
            if (n2 > 1 && this.uniqueSuiteNames && testsCollection.hasReplicatedSuites()) {
                throw new BuildException(String.format(Locale.ROOT, "There are test suites that request JVM replication and the number of forked JVMs %d is larger than 1. Run on a single JVM.", n2));
            }
            ArrayDeque arrayDeque = new ArrayDeque(this.loadBalanceSuites(arrayList, testsCollection, this.balancers));
            eventBus.register(new JUnit4$1(this, arrayDeque));
            object2 = this.getCommandline().getSystemProperties().getVariablesVector();
            Object object3 = ((Vector)object2).iterator();
            while (object3.hasNext()) {
                Environment.Variable variable = (Environment.Variable)object3.next();
                if (!SysGlobals.SYSPROP_TESTFILTER().equals(variable.getKey())) continue;
                try {
                    object = new FilterExpressionParser().parse(variable.getValue());
                    this.log("Parsed test filtering expression: " + ((FilterExpressionParser$Node)object).toExpression(), 2);
                }
                catch (Exception exception) {
                    this.log("Could not parse filtering expression: " + variable.getValue(), exception, 1);
                }
            }
            object3 = new ArrayList();
            for (int i = 0; i < n2; ++i) {
                object = (ForkedJvmInfo)arrayList.get(i);
                object3.add(new JUnit4$2(this, (ForkedJvmInfo)object, eventBus));
            }
            ExecutorService executorService = Executors.newCachedThreadPool();
            eventBus.post(new AggregatedStartEvent(object3.size(), testsCollection.testClasses.size()));
            try {
                object = executorService.invokeAll(object3);
                executorService.shutdown();
                for (int i = 0; i < object3.size(); ++i) {
                    Future object4 = object.get(i);
                    try {
                        object4.get();
                        continue;
                    }
                    catch (ExecutionException executionException) {
                        ((ForkedJvmInfo)arrayList.get((int)i)).executionError = executionException.getCause();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.log("Main JVM interrupted? Weird.", 0);
            }
            eventBus.post(new AggregatedQuitEvent());
            for (ForkedJvmInfo forkedJvmInfo : arrayList) {
                if (forkedJvmInfo.start <= 0L || forkedJvmInfo.end <= 0L) continue;
                this.log(String.format(Locale.ROOT, "JVM J%d: %8.2f .. %8.2f = %8.2fs", forkedJvmInfo.id, Float.valueOf((float)(forkedJvmInfo.start - l) / 1000.0f), Float.valueOf((float)(forkedJvmInfo.end - l) / 1000.0f), Float.valueOf((float)forkedJvmInfo.getExecutionTime() / 1000.0f)), 2);
            }
            this.log("Execution time total: " + Duration.toHumanDuration(System.currentTimeMillis() - l));
            object = null;
            for (ForkedJvmInfo forkedJvmInfo : arrayList) {
                if (forkedJvmInfo.executionError == null) continue;
                this.log("ERROR: JVM J" + forkedJvmInfo.id + " ended with an exception, command line: " + forkedJvmInfo.getCommandLine());
                this.log("ERROR: JVM J" + forkedJvmInfo.id + " ended with an exception: " + Throwables.getStackTraceAsString(forkedJvmInfo.executionError), 0);
                if (object != null) continue;
                object = forkedJvmInfo;
            }
            if (object != null) {
                throw new BuildException("At least one forked process threw an exception, first: " + ((ForkedJvmInfo)object).executionError.getMessage(), ((ForkedJvmInfo)object).executionError);
            }
        }
        TestsSummary testsSummary = testsSummaryEventListener.getResult();
        if (this.printSummary) {
            this.log("Tests summary: " + testsSummary, 2);
        }
        if (!testsSummary.isSuccessful()) {
            if (!Strings.isNullOrEmpty(this.failureProperty)) {
                this.getProject().setNewProperty(this.failureProperty, "true");
            }
            if (this.haltOnFailure) {
                throw new BuildException(String.format(Locale.ROOT, "There were test failures: %s [seed: %s]", testsSummary, this.getSeed()));
            }
        }
        if (!this.leaveTemporary) {
            for (Path path : this.temporaryFiles) {
                try {
                    if (path == null) continue;
                    try {
                        java.nio.file.Files.delete(path);
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        throw new DirectoryNotEmptyException("Remaining files: " + JUnit4.listFiles(path));
                    }
                }
                catch (IOException iOException) {
                    this.log("Could not remove temporary path: " + path.toAbsolutePath() + " (" + iOException + ")", iOException, 1);
                }
            }
        }
        if (this.statsPropertyPrefix != null) {
            Object object;
            object = this.getProject();
            object.setNewProperty(this.statsPropertyPrefix + ".tests", Integer.toString(testsSummary.tests));
            object.setNewProperty(this.statsPropertyPrefix + ".errors", Integer.toString(testsSummary.errors));
            object.setNewProperty(this.statsPropertyPrefix + ".failures", Integer.toString(testsSummary.failures));
            object.setNewProperty(this.statsPropertyPrefix + ".ignores", Integer.toString(testsSummary.ignores));
            object.setNewProperty(this.statsPropertyPrefix + ".suites", Integer.toString(testsSummary.suites));
            object.setNewProperty(this.statsPropertyPrefix + ".assumptions", Integer.toString(testsSummary.assumptions));
            object.setNewProperty(this.statsPropertyPrefix + ".suiteErrors", Integer.toString(testsSummary.suiteErrors));
            object.setNewProperty(this.statsPropertyPrefix + ".nonIgnored", Integer.toString(testsSummary.getNonIgnoredTestsCount()));
            object.setNewProperty(this.statsPropertyPrefix + ".successful", Boolean.toString(testsSummary.isSuccessful()));
        }
        if ((n = testsSummary.getNonIgnoredTestsCount()) == 0) {
            String string2 = "There were no executed tests: " + testsSummary;
            switch (this.ifNoTests) {
                case FAIL: {
                    throw new BuildException(string2);
                }
                case WARN: {
                    this.log(string2, 1);
                    break;
                }
                case IGNORE: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable case clause: " + (Object)((Object)this.ifNoTests));
                }
            }
        }
    }

    private static List listFiles(Path path) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (DirectoryStream<Path> directoryStream = java.nio.file.Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                arrayList.add(path2.toString());
            }
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    private void validateArguments() {
        Path path = this.getTempDir();
        if (path == null) {
            throw new BuildException("Temporary directory cannot be null.");
        }
        if (java.nio.file.Files.exists(path, new LinkOption[0])) {
            if (!java.nio.file.Files.isDirectory(path, new LinkOption[0])) {
                throw new BuildException("Temporary directory is not a folder: " + path.toAbsolutePath());
            }
        } else {
            try {
                java.nio.file.Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new BuildException("Failed to create temporary folder: " + path, (Throwable)iOException);
            }
        }
    }

    private void validateJUnit4() {
        try {
            Class<?> clazz = Class.forName("org.junit.runner.Description");
            if (!Serializable.class.isAssignableFrom(clazz)) {
                throw new BuildException("At least JUnit version 4.10 is required on junit4's taskdef classpath.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("JUnit JAR must be added to junit4 taskdef's classpath.");
        }
    }

    private List loadBalanceSuites(List list, TestsCollection testsCollection, List list2) {
        Object object;
        Iterator iterator2;
        Object object322;
        Map map = this.sortAndSplitReplicated(testsCollection.testClasses);
        Collection collection = (Collection)map.get(true);
        Collection collection2 = (Collection)map.get(false);
        ArrayList<RoundRobinBalancer> arrayList = new ArrayList<RoundRobinBalancer>(list2);
        arrayList.add(new RoundRobinBalancer());
        ArrayList arrayList2 = new ArrayList(collection2);
        Collections.sort(arrayList2);
        HashMap hashMap = new HashMap();
        for (Object object322 : list) {
            hashMap.put(((ForkedJvmInfo)object322).id, new ArrayList());
        }
        int n = list.size();
        for (SuiteBalancer object22 : arrayList) {
            object22.setOwner(this);
            iterator2 = object22.assign(Collections.unmodifiableCollection(arrayList2), n, this.mainSeed());
            object = iterator2.iterator();
            while (object.hasNext()) {
                SuiteBalancer$Assignment suiteBalancer$Assignment = (SuiteBalancer$Assignment)object.next();
                if (suiteBalancer$Assignment == null) {
                    throw new RuntimeException("Balancer must return non-null assignments.");
                }
                if (!arrayList2.remove(suiteBalancer$Assignment.suiteName)) {
                    throw new RuntimeException("Balancer must return suite name as a key: " + suiteBalancer$Assignment.suiteName);
                }
                this.log(String.format(Locale.ROOT, "Assignment hint: J%-2d (cost %5d) %s (by %s)", suiteBalancer$Assignment.forkedJvmId, suiteBalancer$Assignment.estimatedCost, suiteBalancer$Assignment.suiteName, object22.getClass().getSimpleName()), 3);
                ((List)hashMap.get(suiteBalancer$Assignment.forkedJvmId)).add(suiteBalancer$Assignment);
            }
        }
        if (arrayList2.size() != 0) {
            throw new RuntimeException("Not all suites assigned?: " + arrayList2);
        }
        if (this.shuffleOnForkedJvm) {
            for (List list3 : hashMap.values()) {
                Collections.sort(list3);
                Collections.shuffle(list3, new Random(this.mainSeed()));
            }
        }
        object322 = new ArrayList();
        for (Iterator iterator2 : list) {
            List<String> list4;
            object = (List)hashMap.get(((ForkedJvmInfo)((Object)iterator2)).id);
            int n2 = (int)((float)object.size() * this.dynamicAssignmentRatio);
            if (n2 > 0) {
                list4 = object.subList(object.size() - n2, object.size());
                for (SuiteBalancer$Assignment suiteBalancer$Assignment : list4) {
                    object322.add(new SuiteHint(suiteBalancer$Assignment.suiteName, suiteBalancer$Assignment.estimatedCost));
                }
                list4.clear();
            }
            ((ForkedJvmInfo)((Object)iterator2)).testSuites = new ArrayList();
            list4 = ((ForkedJvmInfo)((Object)iterator2)).testSuites;
            Iterator iterator3 = object.iterator();
            while (iterator3.hasNext()) {
                SuiteBalancer$Assignment suiteBalancer$Assignment = (SuiteBalancer$Assignment)iterator3.next();
                ((ArrayList)list4).add(suiteBalancer$Assignment.suiteName);
            }
        }
        Collections.sort(object322, SuiteHint.DESCENDING_BY_WEIGHT);
        if (!collection.isEmpty()) {
            for (Iterator iterator2 : list) {
                for (String string : collection) {
                    ((ForkedJvmInfo)((Object)iterator2)).testSuites.add(string);
                }
                if (!this.shuffleOnForkedJvm) continue;
                Collections.shuffle(((ForkedJvmInfo)((Object)iterator2)).testSuites, new Random(this.mainSeed()));
            }
        }
        for (Iterator iterator2 : list) {
            this.log("Forked JVM J" + ((ForkedJvmInfo)((Object)iterator2)).id + " assignments (after shuffle):", 3);
            for (String string : ((ForkedJvmInfo)((Object)iterator2)).testSuites) {
                this.log("  " + string, 3);
            }
        }
        this.log("Stealing queue:", 3);
        Iterator iterator4 = object322.iterator();
        while (iterator4.hasNext()) {
            iterator2 = (SuiteHint)iterator4.next();
            this.log("  " + ((SuiteHint)((Object)iterator2)).suiteName + " " + ((SuiteHint)((Object)iterator2)).cost, 3);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>(object322.size());
        iterator2 = object322.iterator();
        while (iterator2.hasNext()) {
            object = (SuiteHint)iterator2.next();
            arrayList3.add(((SuiteHint)object).suiteName);
        }
        return arrayList3;
    }

    private Map sortAndSplitReplicated(List list) {
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new JUnit4$3(this));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (TestClass testClass : arrayList) {
            if (testClass.replicate) {
                arrayList2.add(testClass.className);
                continue;
            }
            arrayList3.add(testClass.className);
        }
        HashMap hashMap = new HashMap();
        hashMap.put(Boolean.TRUE, arrayList2);
        hashMap.put(Boolean.FALSE, arrayList3);
        return hashMap;
    }

    private long mainSeed() {
        long[] lArray = SeedUtils.parseSeedChain(this.getSeed());
        if (lArray.length < 1) {
            throw new BuildException("Random seed is required.");
        }
        return lArray[0];
    }

    private org.apache.tools.ant.types.Path resolveFiles(org.apache.tools.ant.types.Path path) {
        org.apache.tools.ant.types.Path path2 = new org.apache.tools.ant.types.Path(this.getProject());
        for (String string : path.list()) {
            path2.createPathElement().setLocation(new File(string));
        }
        return path2;
    }

    private int determineForkedJvmCount(TestsCollection testsCollection) {
        int n;
        int n2 = Runtime.getRuntime().availableProcessors();
        if (this.parallelism.equals(PARALLELISM_AUTO)) {
            n = n2 >= 8 ? 4 : (n2 >= 4 ? 3 : (n2 == 3 ? 2 : 1));
        } else if (this.parallelism.equals(PARALLELISM_MAX)) {
            n = Runtime.getRuntime().availableProcessors();
        } else {
            try {
                n = Math.max(1, Integer.parseInt(this.parallelism));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BuildException("parallelism must be 'auto', 'max' or a valid integer: " + this.parallelism);
            }
        }
        if (!testsCollection.hasReplicatedSuites()) {
            n = Math.min(testsCollection.testClasses.size(), n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void forkJvm(ForkedJvmInfo forkedJvmInfo, EventBus eventBus) {
        AtomicBoolean atomicBoolean;
        AtomicReference atomicReference;
        DiagnosticsListener diagnosticsListener;
        Path path;
        Path path2;
        Path path3;
        Path path4;
        Path path5;
        block29: {
            Closer closer;
            block28: {
                Object object;
                String string = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS", Locale.ROOT).format(new Date());
                path5 = this.tempFile(string, "junit4-J" + forkedJvmInfo.id, ".suites", this.getTempDir());
                this.temporaryFiles.add(path5);
                path4 = this.tempFile(string, "junit4-J" + forkedJvmInfo.id, ".dynamic-suites", this.getTempDir());
                path3 = this.tempFile(string, "junit4-J" + forkedJvmInfo.id, ".spill", this.getTempDir());
                String string2 = Joiner.on("\n").join(forkedJvmInfo.testSuites);
                this.log("Test class names:\n" + string2, 3);
                java.nio.file.Files.write(path5, string2.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                CommandlineJava commandlineJava = (CommandlineJava)this.getCommandline().clone();
                commandlineJava.createClasspath(this.getProject()).add(this.addForkedJvmClasspath());
                commandlineJava.setClassname(ForkedMainSafe.class.getName());
                if (forkedJvmInfo.forkedJvmCount == 1) {
                    commandlineJava.createArgument().setValue("-flush");
                }
                path2 = this.tempFile(string, "junit4-J" + forkedJvmInfo.id, ".sysout", this.getTempDir());
                path = this.tempFile(string, "junit4-J" + forkedJvmInfo.id, ".syserr", this.getTempDir());
                Path path6 = this.tempFile(string, "junit4-J" + forkedJvmInfo.id, ".events", this.getTempDir());
                this.temporaryFiles.add(path6);
                commandlineJava.createArgument().setValue("-eventsfile");
                commandlineJava.createArgument().setFile(path6.toFile());
                if (this.sysouts) {
                    commandlineJava.createArgument().setValue("-sysouts");
                }
                if (this.debugStream) {
                    commandlineJava.createArgument().setValue("-debug");
                }
                TailInputStream tailInputStream = new TailInputStream(path6);
                if (!this.runListeners.isEmpty()) {
                    object = this.runListeners.stream().map(runListenerClass -> runListenerClass.getClassName()).collect(Collectors.joining(","));
                    commandlineJava.createArgument().setValue("-runListeners");
                    commandlineJava.createArgument().setValue((String)object);
                }
                commandlineJava.createArgument().setValue("@" + path5.toAbsolutePath().normalize());
                if (this.dynamicAssignmentRatio > 0.0f) {
                    commandlineJava.createArgument().setValue("-stdin");
                }
                object = new EventBus("forked-" + forkedJvmInfo.id);
                diagnosticsListener = new DiagnosticsListener(forkedJvmInfo, this);
                ((EventBus)object).register(diagnosticsListener);
                ((EventBus)object).register(new AggregatingListener(eventBus, forkedJvmInfo));
                atomicReference = new AtomicReference();
                atomicBoolean = new AtomicBoolean();
                PrintWriter printWriter = new PrintWriter(java.nio.file.Files.newBufferedWriter(path4, StandardCharsets.UTF_8, new OpenOption[0]));
                ((EventBus)object).register(new JUnit4$4(this, eventBus, atomicReference, atomicBoolean, forkedJvmInfo, printWriter));
                closer = Closer.create();
                closer.register(tailInputStream);
                closer.register(printWriter);
                OutputStream outputStream = (OutputStream)closer.register(new BufferedOutputStream(java.nio.file.Files.newOutputStream(path2, new OpenOption[0])));
                OutputStream outputStream2 = (OutputStream)closer.register(new BufferedOutputStream(java.nio.file.Files.newOutputStream(path, new OpenOption[0])));
                RandomAccessFile randomAccessFile = (RandomAccessFile)closer.register(new RandomAccessFile(path3.toFile(), "rw"));
                Execute execute = this.forkProcess(forkedJvmInfo, (EventBus)object, commandlineJava, tailInputStream, outputStream, outputStream2, randomAccessFile);
                this.log("Forked JVM J" + forkedJvmInfo.id + " finished with exit code: " + execute.getExitValue(), 4);
                if (!execute.isFailure()) break block28;
                int n = execute.getExitValue();
                switch (n) {
                    case 239: {
                        throw new BuildException("Forked JVM's classpath must include a junit4 JAR.");
                    }
                    case 238: {
                        throw new BuildException("Forked JVM's classpath must use JUnit 4.10 or newer.");
                    }
                }
                Closeables.close(outputStream, false);
                Closeables.close(outputStream2, false);
                StringBuilder stringBuilder = new StringBuilder();
                if (n == 237) {
                    stringBuilder.append("Forked JVM ran out of memory.");
                } else {
                    stringBuilder.append("Forked process returned with error code: ").append(n).append(".");
                }
                if (java.nio.file.Files.size(path2) > 0L || java.nio.file.Files.size(path) > 0L) {
                    if (n != 237) {
                        stringBuilder.append(" Very likely a JVM crash. ");
                    }
                    if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.PIPE)) {
                        stringBuilder.append(" Process output piped in logs above.");
                    } else if (!this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.IGNORE)) {
                        if (java.nio.file.Files.size(path2) > 0L) {
                            stringBuilder.append(" See process stdout at: " + path2.toAbsolutePath());
                        }
                        if (java.nio.file.Files.size(path) > 0L) {
                            stringBuilder.append(" See process stderr at: " + path.toAbsolutePath());
                        }
                    }
                }
                throw new BuildException(stringBuilder.toString());
            }
            try {
                closer.close();
            }
            catch (Throwable throwable) {
                Files.asByteSource(path4.toFile()).copyTo(Files.asByteSink(path5.toFile(), FileWriteMode.APPEND));
                java.nio.file.Files.delete(path4);
                java.nio.file.Files.delete(path3);
                this.checkJvmOutput(eventBus, path2, forkedJvmInfo, "stdout");
                this.checkJvmOutput(eventBus, path, forkedJvmInfo, "stderr");
                throw throwable;
            }
            break block29;
            catch (Throwable throwable) {
                try {
                    throw closer.rethrow(throwable);
                }
                catch (Throwable throwable2) {
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable3) {
                        Files.asByteSource(path4.toFile()).copyTo(Files.asByteSink(path5.toFile(), FileWriteMode.APPEND));
                        java.nio.file.Files.delete(path4);
                        java.nio.file.Files.delete(path3);
                        this.checkJvmOutput(eventBus, path2, forkedJvmInfo, "stdout");
                        this.checkJvmOutput(eventBus, path, forkedJvmInfo, "stderr");
                        throw throwable3;
                    }
                    Files.asByteSource(path4.toFile()).copyTo(Files.asByteSink(path5.toFile(), FileWriteMode.APPEND));
                    java.nio.file.Files.delete(path4);
                    java.nio.file.Files.delete(path3);
                    this.checkJvmOutput(eventBus, path2, forkedJvmInfo, "stdout");
                    this.checkJvmOutput(eventBus, path, forkedJvmInfo, "stderr");
                    throw throwable2;
                }
            }
        }
        Files.asByteSource(path4.toFile()).copyTo(Files.asByteSink(path5.toFile(), FileWriteMode.APPEND));
        java.nio.file.Files.delete(path4);
        java.nio.file.Files.delete(path3);
        this.checkJvmOutput(eventBus, path2, forkedJvmInfo, "stdout");
        this.checkJvmOutput(eventBus, path, forkedJvmInfo, "stderr");
        if (!diagnosticsListener.quitReceived()) {
            throw new BuildException("Quit event not received from the forked process? This may indicate JVM crash or runner bugs.");
        }
        if (atomicBoolean.get() && this.dynamicAssignmentRatio > 0.0f) {
            throw new BuildException("Forked JVM J" + forkedJvmInfo.id + " was not be able to decode class names when using charset: " + atomicReference + ". Do not use dynamic suite balancing to work around this problem (-DdynamicAssignmentRatio=0).");
        }
    }

    private void checkJvmOutput(EventBus eventBus, Path path, ForkedJvmInfo forkedJvmInfo, String string) {
        if (java.nio.file.Files.size(path) > 0L) {
            String string2 = "JVM J" + forkedJvmInfo.id + ": " + string + " was not empty, see: " + path;
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.WARN)) {
                this.log(string2, 1);
            }
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.LISTENERS)) {
                eventBus.post(new JvmOutputEvent(forkedJvmInfo, path.toFile()));
            }
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.PIPE)) {
                this.log(">>> JVM J" + forkedJvmInfo.id + ": " + string + " (verbatim) ----", 2);
                try {
                    if (java.nio.file.Files.size(path) < 0xA00000L) {
                        this.log(new String(java.nio.file.Files.readAllBytes(path), forkedJvmInfo.getCharset()), 2);
                    } else {
                        CharStreams.copy(java.nio.file.Files.newBufferedReader(path, forkedJvmInfo.getCharset()), System.out);
                    }
                }
                catch (IOException iOException) {
                    this.log("Couldn't pipe file " + path + ": " + iOException.toString(), 2);
                }
                this.log("<<< JVM J" + forkedJvmInfo.id + ": EOF ----", 2);
            }
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.IGNORE)) {
                java.nio.file.Files.delete(path);
            }
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.FAIL)) {
                throw new BuildException(string2);
            }
            return;
        }
        java.nio.file.Files.delete(path);
    }

    private Path tempFile(String string, String string2, String string3, Path path) {
        return java.nio.file.Files.createTempFile(path, string2 + "-" + string, string3, new FileAttribute[0]);
    }

    private String escapeAndJoin(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile("[\\ ]");
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (pattern.matcher(string).find()) {
                stringBuilder.append('\"').append(string).append('\"');
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private Execute forkProcess(ForkedJvmInfo forkedJvmInfo, EventBus eventBus, CommandlineJava commandlineJava, TailInputStream tailInputStream, OutputStream outputStream, OutputStream outputStream2, RandomAccessFile randomAccessFile) {
        try {
            String string = commandlineJava.getSystemProperties().getVariablesVector().stream().filter(variable -> variable.getKey().equals("java.io.tmpdir")).map(variable -> variable.getValue()).findAny().orElse(null);
            LocalForkedJvmStreamHandler localForkedJvmStreamHandler = new LocalForkedJvmStreamHandler(eventBus, (ClassLoader)this.testsClassLoader, System.err, tailInputStream, outputStream, outputStream2, this.heartbeat, randomAccessFile);
            Path path = this.getWorkingDirectory(forkedJvmInfo, string);
            Environment.Variable variable2 = new Environment.Variable();
            variable2.setKey(CHILDVM_SYSPROP_CWD);
            variable2.setFile(path.toAbsolutePath().normalize().toFile());
            commandlineJava.addSysproperty(variable2);
            variable2 = new Environment.Variable();
            variable2.setKey(SYSPROP_TEMPDIR);
            variable2.setFile(this.getTempDir().toAbsolutePath().normalize().toFile());
            commandlineJava.addSysproperty(variable2);
            variable2 = new Environment.Variable();
            variable2.setKey("junit4.childvm.id");
            variable2.setValue(Integer.toString(forkedJvmInfo.id));
            commandlineJava.addSysproperty(variable2);
            variable2 = new Environment.Variable();
            variable2.setKey("junit4.childvm.count");
            variable2.setValue(Integer.toString(forkedJvmInfo.forkedJvmCount));
            commandlineJava.addSysproperty(variable2);
            forkedJvmInfo.forkedCommandLine = this.escapeAndJoin(commandlineJava.getCommandline());
            this.log("Forked child JVM at '" + path.toAbsolutePath().normalize() + "', command (may need escape sequences for your shell):\n" + forkedJvmInfo.forkedCommandLine, 3);
            Execute execute = new Execute();
            execute.setCommandline(commandlineJava.getCommandline());
            execute.setVMLauncher(true);
            execute.setWorkingDirectory(path.toFile());
            execute.setStreamHandler((ExecuteStreamHandler)localForkedJvmStreamHandler);
            execute.setNewenvironment(this.newEnvironment);
            if (this.env.getVariables() != null) {
                execute.setEnvironment(this.env.getVariables());
            }
            this.log("Starting JVM J" + forkedJvmInfo.id, 4);
            execute.execute();
            return execute;
        }
        catch (IOException iOException) {
            throw new BuildException("Could not start the child process. Run ant with -verbose to get the execution details.", (Throwable)iOException);
        }
    }

    private Path getWorkingDirectory(ForkedJvmInfo forkedJvmInfo, String string) {
        Path path;
        Path path2;
        Path path3 = path2 = this.dir == null ? this.getProject().getBaseDir().toPath() : this.dir;
        if (this.isolateWorkingDirectories) {
            path = path2.resolve("J" + forkedJvmInfo.id);
            if (java.nio.file.Files.isDirectory(path, new LinkOption[0])) {
                List list = JUnit4.listFiles(path);
                if (!list.isEmpty()) {
                    switch (this.nonEmptyWorkDirAction) {
                        case IGNORE: {
                            this.log("Cwd of a forked JVM already exists and is not empty: " + list + " (ignoring).", 4);
                            break;
                        }
                        case WIPE: {
                            this.log("Cwd of a forked JVM already exists and is not empty, trying to wipe: " + list, 4);
                            try {
                                Path path4 = string == null ? null : path.resolve(string);
                                java.nio.file.Files.walkFileTree(path, new JUnit4$5(this, path, path4));
                                break;
                            }
                            catch (IOException iOException) {
                                throw new BuildException("An exception occurred while trying to wipe the working directory: " + path, (Throwable)iOException);
                            }
                        }
                        case FAIL: {
                            throw new BuildException("Cwd of a forked JVM already exists and is not empty and setOnNonEmptyWorkDirectory=" + (Object)((Object)this.nonEmptyWorkDirAction) + ": " + list);
                        }
                        default: {
                            throw new RuntimeException("Unreachable.");
                        }
                    }
                }
            } else {
                java.nio.file.Files.createDirectories(path, new FileAttribute[0]);
                this.temporaryFiles.add(path);
            }
        } else {
            path = path2;
        }
        return path;
    }

    private Path getTempDir() {
        if (this.tempDir == null) {
            this.tempDir = this.dir != null ? this.dir : this.getProject().getBaseDir().toPath();
        }
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestsCollection processTestResources() {
        Object object;
        Object object2;
        Object object3;
        TestsCollection testsCollection = new TestsCollection();
        this.resources.setProject(this.getProject());
        Iterator iterator = this.resources.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            object3 = (Resource)iterator.next();
            if (!object3.isExists()) {
                throw new BuildException("Test class resource does not exist?: " + object3.getName());
            }
            try {
                if (object3.getName().endsWith(".java")) {
                    object2 = object3.getName();
                    object = ((String)object2).substring(0, ((String)object2).length() - ".java".length());
                    object = ((String)object).replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.');
                    testsCollection.add(new TestClass((String)object));
                    if (bl) continue;
                    this.log("Source (.java) files used for naming source suites. This is discouraged, use a resource collection pointing to .class files instead.", 2);
                    bl = true;
                    continue;
                }
                object2 = object3.getInputStream();
                if (!((InputStream)object2).markSupported()) {
                    object2 = new BufferedInputStream((InputStream)object2);
                }
                try {
                    ((InputStream)object2).mark(4);
                    if (((InputStream)object2).read() != 202 || ((InputStream)object2).read() != 254 || ((InputStream)object2).read() != 186 || ((InputStream)object2).read() != 190) {
                        throw new BuildException("File does not start with a class magic 0xcafebabe: " + object3.getName() + ", " + object3.getLocation());
                    }
                    ((InputStream)object2).reset();
                    object = "com.carrotsearch.randomizedtesting.annotations.ReplicateOnEachVm";
                    TestClass testClass = new TestClass();
                    ClassReader classReader = new ClassReader((InputStream)object2);
                    JUnit4$6 jUnit4$6 = new JUnit4$6(this, 589824, testClass);
                    classReader.accept(jUnit4$6, 7);
                    testClass.className = classReader.getClassName().replace('/', '.');
                    this.log("Test class parsed: " + object3.getName() + " as " + testClass.className, 4);
                    testsCollection.add(testClass);
                }
                finally {
                    ((InputStream)object2).close();
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Could not read or parse as Java class: " + object3.getName() + ", " + object3.getLocation(), (Throwable)iOException);
            }
        }
        object3 = Strings.emptyToNull(this.getProject().getProperty(SysGlobals.SYSPROP_TESTCLASS()));
        if (object3 != null) {
            object2 = new ClassGlobFilter((String)object3);
            object = testsCollection.testClasses.iterator();
            while (object.hasNext()) {
                if (((ClassGlobFilter)((Object)object2)).shouldRun(Description.createSuiteDescription((String)((TestClass)object.next()).className, (Annotation[])new Annotation[0]))) continue;
                object.remove();
            }
        }
        return testsCollection;
    }

    private CommandlineJava getCommandline() {
        return this.forkedJvmCommandLine;
    }

    private org.apache.tools.ant.types.Path addForkedJvmClasspath() {
        org.apache.tools.ant.types.Path path = new org.apache.tools.ant.types.Path(this.getProject());
        String[] stringArray = new String[]{ForkedMain.class.getName(), Strings.class.getName(), MethodGlobFilter.class.getName(), TeeOutputStream.class.getName()};
        for (String string : Arrays.asList(stringArray)) {
            String string2 = string.replace(".", "/") + ".class";
            File file = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)string2);
            if (file != null) {
                path.createPath().setLocation(file);
                continue;
            }
            throw new BuildException("Could not locate classpath for resource: " + string2);
        }
        return path;
    }

    static /* synthetic */ void access$000(JUnit4 jUnit4, ForkedJvmInfo forkedJvmInfo, EventBus eventBus) {
        jUnit4.forkJvm(forkedJvmInfo, eventBus);
    }
}

