/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.blueprint.KarafBundleStateService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintCamelStateService {
    public static final Logger LOG = LoggerFactory.getLogger(BlueprintCamelStateService.class);
    private Map<String, State> states;
    private Map<String, Throwable> exceptions;
    private BundleContext bundleContext;
    private ServiceRegistration<?> registration;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setBundleState(Bundle bundle, String contextId, State state) {
        this.setBundleState(bundle, contextId, state, null);
    }

    public void setBundleState(Bundle bundle, String contextId, State state, Throwable t) {
        if (state == State.Failure) {
            LOG.warn("Changing Camel state for bundle {} to {}", (Object)bundle.getBundleId(), (Object)state);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Changing Camel state for bundle {} to {}", (Object)bundle.getBundleId(), (Object)state);
        }
        String key = String.format("%d:%s", bundle.getBundleId(), contextId);
        if (state != null) {
            this.states.put(key, state);
        } else {
            this.states.remove(key);
        }
        if (t != null) {
            this.exceptions.put(key, t);
        } else {
            this.exceptions.remove(key);
        }
    }

    public List<State> getStates(Bundle bundle) {
        LinkedList<State> result = new LinkedList<State>();
        for (Map.Entry<String, State> e : this.states.entrySet()) {
            if (!e.getKey().startsWith(bundle.getBundleId() + ":")) continue;
            result.add(e.getValue());
        }
        return result;
    }

    public Map<String, Throwable> getExceptions(Bundle bundle) {
        LinkedHashMap<String, Throwable> result = new LinkedHashMap<String, Throwable>();
        for (Map.Entry<String, Throwable> e : this.exceptions.entrySet()) {
            if (!e.getKey().startsWith(bundle.getBundleId() + ":")) continue;
            result.put(e.getKey().substring(e.getKey().indexOf(":") + 1), e.getValue());
        }
        return result;
    }

    public void init() {
        try {
            this.states = new ConcurrentHashMap<String, State>();
            this.exceptions = new ConcurrentHashMap<String, Throwable>();
            this.registration = new KarafBundleStateServiceCreator().create(this.bundleContext, this);
        }
        catch (NoClassDefFoundError e) {
            LOG.info("Karaf BundleStateService not accessible. Bundle state won't reflect Camel context state");
        }
    }

    public void destroy() {
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.states.clear();
        this.states = null;
        this.exceptions.clear();
        this.exceptions = null;
    }

    private static class KarafBundleStateServiceCreator {
        private KarafBundleStateServiceCreator() {
        }

        public ServiceRegistration<?> create(BundleContext context, BlueprintCamelStateService camelStateService) {
            KarafBundleStateService karafBundleStateService = new KarafBundleStateService(camelStateService);
            return karafBundleStateService.register(context);
        }
    }

    public static enum State {
        Starting,
        Active,
        Failure;

    }
}

