/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.artifact;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.eclipse.aether.artifact.AbstractArtifact;
import shaded.org.eclipse.aether.artifact.ArtifactType;

public final class DefaultArtifact
extends AbstractArtifact {
    private static final Pattern COORDINATE_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;

    public DefaultArtifact(String coords) {
        this(coords, Collections.emptyMap());
    }

    public DefaultArtifact(String coords, Map<String, String> properties) {
        Matcher m = COORDINATE_PATTERN.matcher(coords);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coords + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        this.groupId = m.group(1);
        this.artifactId = m.group(2);
        this.extension = DefaultArtifact.get(m.group(4), "jar");
        this.classifier = DefaultArtifact.get(m.group(6), "");
        this.version = m.group(7);
        this.file = null;
        this.properties = DefaultArtifact.copyProperties(properties);
    }

    private static String get(String value, String defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : value;
    }

    public DefaultArtifact(String groupId, String artifactId, String extension, String version) {
        this(groupId, artifactId, "", extension, version);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version) {
        this(groupId, artifactId, classifier, extension, version, null, (File)null);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, ArtifactType type) {
        this(groupId, artifactId, classifier, extension, version, null, type);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, Map<String, String> properties, ArtifactType type) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = classifier != null || type == null ? DefaultArtifact.emptify(classifier) : DefaultArtifact.emptify(type.getClassifier());
        this.extension = extension != null || type == null ? DefaultArtifact.emptify(extension) : DefaultArtifact.emptify(type.getExtension());
        this.version = DefaultArtifact.emptify(version);
        this.file = null;
        this.properties = DefaultArtifact.mergeArtifactProperties(properties, type != null ? type.getProperties() : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> mergeArtifactProperties(Map<String, String> artifactProperties, Map<String, String> typeDefaultProperties) {
        if (artifactProperties == null || artifactProperties.isEmpty()) {
            if (typeDefaultProperties == null) return Collections.emptyMap();
            if (!typeDefaultProperties.isEmpty()) return typeDefaultProperties;
            return Collections.emptyMap();
        }
        Map<String, String> properties = new HashMap();
        if (typeDefaultProperties != null) {
            properties.putAll(typeDefaultProperties);
        }
        if (artifactProperties == null) return Collections.unmodifiableMap(properties);
        properties.putAll(artifactProperties);
        return Collections.unmodifiableMap(properties);
    }

    public DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, Map<String, String> properties, File file) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = DefaultArtifact.emptify(classifier);
        this.extension = DefaultArtifact.emptify(extension);
        this.version = DefaultArtifact.emptify(version);
        this.file = file;
        this.properties = DefaultArtifact.copyProperties(properties);
    }

    DefaultArtifact(String groupId, String artifactId, String classifier, String extension, String version, File file, Map<String, String> properties) {
        this.groupId = DefaultArtifact.emptify(groupId);
        this.artifactId = DefaultArtifact.emptify(artifactId);
        this.classifier = DefaultArtifact.emptify(classifier);
        this.extension = DefaultArtifact.emptify(extension);
        this.version = DefaultArtifact.emptify(version);
        this.file = file;
        this.properties = properties;
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

