/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.build.model.EE;
import aQute.bnd.classindex.ClassIndexerAnalyzer;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import aQute.bnd.osgi.resource.DeferredValue;
import aQute.bnd.osgi.resource.FileResourceCache;
import aQute.bnd.osgi.resource.FilterBuilder;
import aQute.bnd.osgi.resource.MainClassNamespace;
import aQute.bnd.osgi.resource.RequirementBuilder;
import aQute.bnd.osgi.resource.ResourceImpl;
import aQute.bnd.unmodifiable.Lists;
import aQute.bnd.version.VersionRange;
import aQute.lib.converter.Converter;
import aQute.lib.filter.Filter;
import aQute.lib.hex.Hex;
import aQute.lib.hierarchy.FolderNode;
import aQute.lib.hierarchy.Hierarchy;
import aQute.lib.hierarchy.NamedNode;
import aQute.lib.zip.JarIndex;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class ResourceBuilder {
    private final ResourceImpl resource = new ResourceImpl();
    private final Map<String, Set<Capability>> capabilities = new TreeMap<String, Set<Capability>>(new NamespaceComparator());
    private final Map<String, Set<Requirement>> requirements = new TreeMap<String, Set<Requirement>>(new NamespaceComparator());
    private ReporterAdapter reporter = new ReporterAdapter();
    private boolean built = false;

    public ResourceBuilder() {
    }

    public ResourceBuilder(org.osgi.resource.Resource source) {
        this();
        this.addResource(source);
    }

    public ResourceBuilder addResource(org.osgi.resource.Resource source) {
        this.addCapabilities(source.getCapabilities(null));
        this.addRequirements(source.getRequirements(null));
        return this;
    }

    public ResourceBuilder addCapability(Capability capability) {
        CapReqBuilder builder = CapReqBuilder.clone(capability);
        return this.addCapability(builder);
    }

    public ResourceBuilder addCapability(CapReqBuilder builder) {
        if (builder == null) {
            return this;
        }
        if (this.built) {
            throw new IllegalStateException("Resource already built");
        }
        this.addCapability0(builder);
        return this;
    }

    private Capability addCapability0(CapReqBuilder builder) {
        Capability cap = this.buildCapability(builder);
        ResourceBuilder.add(this.capabilities, cap.getNamespace(), cap);
        return cap;
    }

    private static <CR> void add(Map<String, Set<CR>> map, String namespace, CR capreq) {
        map.computeIfAbsent(namespace, k -> new LinkedHashSet()).add(capreq);
    }

    private static <CR> List<CR> flatten(Map<String, Set<CR>> map) {
        return map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected Capability buildCapability(CapReqBuilder builder) {
        Capability cap = builder.setResource(this.resource).buildCapability();
        return cap;
    }

    public ResourceBuilder addRequirement(Requirement requirement) {
        if (requirement == null) {
            return this;
        }
        CapReqBuilder builder = CapReqBuilder.clone(requirement);
        return this.addRequirement(builder);
    }

    public ResourceBuilder addRequirement(CapReqBuilder builder) {
        if (builder == null) {
            return this;
        }
        if (this.built) {
            throw new IllegalStateException("Resource already built");
        }
        this.addRequirement0(builder);
        return this;
    }

    private Requirement addRequirement0(CapReqBuilder builder) {
        Requirement req = this.buildRequirement(builder);
        ResourceBuilder.add(this.requirements, req.getNamespace(), req);
        return req;
    }

    protected Requirement buildRequirement(CapReqBuilder builder) {
        Requirement req = builder.setResource(this.resource).buildRequirement();
        return req;
    }

    public org.osgi.resource.Resource build() {
        if (this.built) {
            throw new IllegalStateException("Resource already built");
        }
        this.built = true;
        this.resource.setCapabilities(ResourceBuilder.flatten(this.capabilities));
        this.resource.setRequirements(ResourceBuilder.flatten(this.requirements));
        return this.resource;
    }

    public List<Capability> getCapabilities() {
        return ResourceBuilder.flatten(this.capabilities);
    }

    public List<Requirement> getRequirements() {
        return ResourceBuilder.flatten(this.requirements);
    }

    public boolean addManifest(Domain manifest) {
        Map.Entry<String, Attrs> fragment;
        Version version;
        String license;
        String docurl;
        String description;
        Map.Entry<String, Attrs> bsn;
        String mainClass = manifest.get("Main-Class");
        if (mainClass != null) {
            CapabilityBuilder mc = new CapabilityBuilder("bnd.mainclass");
            MainClassNamespace.build(mc, manifest);
            this.addCapability(mc);
        }
        if ((bsn = manifest.getBundleSymbolicName()) == null) {
            this.reporter.warning("No BSN set, not a bundle", new Object[0]);
            return false;
        }
        String name = bsn.getKey();
        Attrs attrs = bsn.getValue();
        CapabilityBuilder identity = new CapabilityBuilder("osgi.identity");
        String copyright = manifest.translate("Bundle-Copyright");
        if (copyright != null) {
            identity.addAttribute("copyright", copyright);
        }
        if ((description = manifest.translate("Bundle-Description")) != null) {
            identity.addAttribute("description", description);
        }
        if ((docurl = manifest.get("Bundle-DocURL")) != null) {
            identity.addAttribute("documentation", docurl);
        }
        if ((license = manifest.get("Bundle-License")) != null) {
            identity.addAttribute("license", license);
        }
        identity.addAttributes(attrs);
        identity.addAttribute("osgi.identity", name);
        String versionString = manifest.getBundleVersion();
        try {
            version = Version.parseVersion((String)versionString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid version in bundle " + name, e);
        }
        identity.addAttribute("version", version);
        boolean singleton = "true".equals(attrs.get("singleton:"));
        if (singleton) {
            identity.addDirective("singleton", "true");
        }
        identity.addAttribute("type", (fragment = manifest.getFragmentHost()) == null ? "osgi.bundle" : "osgi.fragment");
        this.addCapability(identity);
        if (fragment == null) {
            CapabilityBuilder bundle = new CapabilityBuilder("osgi.wiring.bundle");
            bundle.addAttributesOrDirectives(attrs);
            bundle.removeDirective("uses").removeDirective("effective");
            bundle.addAttribute("osgi.wiring.bundle", name);
            bundle.addAttribute("bundle-version", version);
            if (singleton) {
                bundle.addDirective("singleton", "true");
            }
            this.addCapability(bundle);
            CapabilityBuilder host = new CapabilityBuilder("osgi.wiring.host");
            host.addAttributesOrDirectives(attrs);
            host.removeDirective("uses").removeDirective("effective");
            host.addAttribute("osgi.wiring.host", name);
            host.addAttribute("bundle-version", version);
            this.addCapability(host);
        } else {
            this.addFragmentHost(fragment.getKey(), fragment.getValue());
        }
        this.addRequireBundles(manifest.getRequireBundle());
        Parameters importServices = OSGiHeader.parseHeader(manifest.get("Import-Service"));
        this.addImportServices(importServices);
        Parameters exportServices = OSGiHeader.parseHeader(manifest.get("Export-Service"));
        this.addExportServices(exportServices);
        this.addExportPackages(manifest.getExportPackage(), name, version);
        this.addImportPackages(manifest.getImportPackage());
        this.addProvideCapabilities(manifest.getProvideCapability());
        this.addRequireCapabilities(manifest.getRequireCapability());
        this.addRequirement(this.getNativeCode(manifest.getBundleNative()));
        return true;
    }

    public void addExportServices(Parameters exportServices) {
        exportServices.stream().mapKey(Processor::removeDuplicateMarker).forEachOrdered((service, attrs) -> {
            CapabilityBuilder cb = new CapabilityBuilder("osgi.service");
            cb.addAttributesOrDirectives((Attrs)attrs);
            cb.addAttribute("objectClass", service);
            this.addCapability(cb);
        });
    }

    public void addImportServices(Parameters importServices) {
        importServices.stream().mapKey(Processor::removeDuplicateMarker).forEachOrdered((service, attrs) -> {
            boolean optional = "optional".equals(attrs.get("availability:"));
            boolean multiple = "true".equalsIgnoreCase(attrs.get("multiple:"));
            StringBuilder filter = new StringBuilder();
            filter.append('(').append("objectClass").append('=').append((String)service).append(')');
            RequirementBuilder rb = new RequirementBuilder("osgi.service");
            rb.addFilter(filter.toString());
            rb.addDirective("effective", "active");
            if (optional) {
                rb.addDirective("resolution", "optional");
            }
            rb.addDirective("cardinality", multiple ? "multiple" : "single");
            this.addRequirement(rb);
        });
    }

    public RequirementBuilder getNativeCode(String header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        Parameters bundleNative = OSGiHeader.parseHeader(header, null, new Parameters(true));
        if (bundleNative.isEmpty()) {
            return null;
        }
        boolean optional = false;
        LinkedList options = new LinkedList();
        RequirementBuilder rb = new RequirementBuilder("osgi.native");
        FilterBuilder sb = new FilterBuilder();
        sb.or();
        for (Map.Entry<String, Attrs> entry : bundleNative.entrySet()) {
            String name = Processor.removeDuplicateMarker(entry.getKey());
            if ("*".equals(name)) {
                optional = true;
                continue;
            }
            sb.and();
            ResourceBuilder.doOr(sb, "osname", "osgi.native.osname", entry.getValue());
            ResourceBuilder.doOr(sb, "processor", "osgi.native.processor", entry.getValue());
            ResourceBuilder.doOr(sb, "language", "osgi.native.language", entry.getValue());
            block13: for (String key : entry.getValue().keySet()) {
                Object value = entry.getValue().getTyped(key);
                switch (key = Processor.removeDuplicateMarker(key)) {
                    case "osname": 
                    case "processor": 
                    case "language": {
                        continue block13;
                    }
                    case "osversion": {
                        sb.eq("osgi.native.osversion", value);
                        continue block13;
                    }
                    case "selection-filter": {
                        String filter = value.toString();
                        String validateFilter = Verifier.validateFilter(filter);
                        if (validateFilter != null) {
                            this.reporter.error("Invalid 'selection-filter' on Bundle-NativeCode %s", filter);
                        }
                        sb.literal(filter);
                        continue block13;
                    }
                }
                this.reporter.warning("Unknown attribute on Bundle-NativeCode header %s=%s", key, value);
            }
            sb.endAnd();
        }
        sb.endOr();
        if (optional) {
            rb.addDirective("resolution", "optional");
        }
        rb.addFilter(sb.toString());
        return rb;
    }

    private static void doOr(FilterBuilder sb, String key, String attribute, Attrs attrs) {
        sb.or();
        while (attrs.containsKey(key)) {
            String[] names;
            try {
                names = Converter.cnv(String[].class, attrs.getTyped(key));
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
            for (String name : names) {
                sb.approximate(attribute, name);
            }
            key = key + '~';
        }
        sb.endOr();
    }

    public void addRequireBundles(Parameters requireBundle) {
        requireBundle.stream().mapKey(Processor::removeDuplicateMarker).forEachOrdered(this::addRequireBundle);
    }

    public void addRequireBundle(String bsn, VersionRange range) {
        Attrs attrs = new Attrs();
        attrs.put("bundle-version", range.toString());
        this.addRequireBundle(bsn, attrs);
    }

    public void addRequireBundle(String bsn, Attrs attrs) {
        RequirementBuilder require = new RequirementBuilder("osgi.wiring.bundle");
        require.addDirectives(attrs).removeDirective("cardinality").removeDirective("effective");
        require.addFilter("osgi.wiring.bundle", bsn, attrs.get("bundle-version"), attrs);
        this.addRequirement(require);
    }

    public void addFragmentHost(String bsn, Attrs attrs) {
        RequirementBuilder require = new RequirementBuilder("osgi.wiring.host");
        require.addDirectives(attrs).removeDirective("cardinality").removeDirective("effective");
        require.addDirective("cardinality", "multiple");
        require.addFilter("osgi.wiring.host", bsn, attrs.get("bundle-version"), attrs);
        this.addRequirement(require);
    }

    public void addRequireCapabilities(Parameters required) {
        required.stream().mapKey(Processor::removeDuplicateMarker).forEachOrdered((namespace, attrs) -> this.addRequireCapability((String)namespace, (String)namespace, (Attrs)attrs));
    }

    public void addRequireCapability(String namespace, String name, Attrs attrs) {
        RequirementBuilder req = new RequirementBuilder(namespace);
        req.addAttributesOrDirectives(attrs);
        this.addRequirement(req);
    }

    public List<Capability> addProvideCapabilities(Parameters capabilities) {
        List<Capability> added = capabilities.stream().mapKey(Processor::removeDuplicateMarker).mapToObj(this::addProvideCapability).collect(Collectors.toList());
        return added;
    }

    public List<Capability> addProvideCapabilities(String clauses) {
        return this.addProvideCapabilities(new Parameters(clauses, this.reporter));
    }

    public Capability addProvideCapability(String namespace, Attrs attrs) {
        CapabilityBuilder builder = new CapabilityBuilder(namespace);
        builder.addAttributesOrDirectives(attrs);
        this.addCapability(builder);
        return this.buildCapability(builder);
    }

    public void addExportPackages(Parameters exports) {
        exports.forEach((name, attrs) -> this.addExportPackage(Processor.removeDuplicateMarker(name), (Attrs)attrs));
    }

    public void addExportPackages(Parameters exports, String bundle_symbolic_name, Version bundle_version) {
        exports.forEach((name, attrs) -> this.addExportPackage(Processor.removeDuplicateMarker(name), (Attrs)attrs, bundle_symbolic_name, bundle_version));
    }

    public void addEE(EE ee) {
        this.addExportPackages(ee.getPackages());
        EE[] compatibles = ee.getCompatible();
        this.addExecutionEnvironment(ee);
        for (EE compatible : compatibles) {
            this.addExecutionEnvironment(compatible);
        }
    }

    public void addExportPackage(String name, Attrs attrs, String bundle_symbolic_name, Version bundle_version) {
        CapabilityBuilder builder = CapReqBuilder.createPackageCapability(name, attrs, bundle_symbolic_name, bundle_version);
        this.addCapability(builder);
    }

    public void addExportPackage(String name, Attrs attrs) {
        this.addExportPackage(name, attrs, null, null);
    }

    public void addImportPackages(Parameters imports) {
        imports.forEach((name, attrs) -> this.addImportPackage(Processor.removeDuplicateMarker(name), (Attrs)attrs));
    }

    public Requirement addImportPackage(String name, Attrs attrs) {
        RequirementBuilder builder = CapReqBuilder.createPackageRequirement(name, attrs, null);
        this.addRequirement(builder);
        return this.buildRequirement(builder);
    }

    public void addExecutionEnvironment(EE ee) {
        CapReqBuilder builder = new CapReqBuilder("osgi.ee");
        builder.addAttribute("osgi.ee", ee.getCapabilityName());
        builder.addAttribute("version", ee.getCapabilityVersion());
        this.addCapability(builder);
        builder = new CapReqBuilder("osgi.ee");
        builder.addAttribute("osgi.ee", ee.getEEName());
        this.addCapability(builder);
    }

    public void addAllExecutionEnvironments(EE ee) {
        this.addExportPackages(ee.getPackages());
        this.addExecutionEnvironment(ee);
        for (EE compatibleEE : ee.getCompatible()) {
            this.addExecutionEnvironment(compatibleEE);
        }
    }

    public void copyCapabilities(Set<String> ignoreNamespaces, org.osgi.resource.Resource r) {
        for (Capability c : r.getCapabilities(null)) {
            if (ignoreNamespaces.contains(c.getNamespace())) continue;
            this.addCapability(c);
        }
    }

    public void addCapabilities(List<Capability> capabilities) {
        if (capabilities == null || capabilities.isEmpty()) {
            return;
        }
        for (Capability c : capabilities) {
            this.addCapability(c);
        }
    }

    public void addRequirement(List<Requirement> requirements) {
        if (requirements == null || requirements.isEmpty()) {
            return;
        }
        for (Requirement rq : requirements) {
            this.addRequirement(rq);
        }
    }

    public void addRequirements(List<Requirement> requires) {
        for (Requirement req : requires) {
            this.addRequirement(req);
        }
    }

    public List<Capability> findCapabilities(String ns, String filter) {
        if (filter == null || this.capabilities.isEmpty()) {
            return Lists.of();
        }
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        Filter f = new Filter(filter);
        for (Capability c : this.getCapabilities()) {
            Map attributes;
            if (ns != null && !ns.equals(c.getNamespace()) || (attributes = c.getAttributes()) == null) continue;
            try {
                if (!f.matchMap(attributes)) continue;
                capabilities.add(c);
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        }
        return capabilities;
    }

    public Map<Capability, Capability> from(org.osgi.resource.Resource bundle) {
        LinkedHashMap<Capability, Capability> mapping = new LinkedHashMap<Capability, Capability>();
        this.addRequirements(bundle.getRequirements(null));
        for (Capability c : bundle.getCapabilities(null)) {
            CapReqBuilder clone = CapReqBuilder.clone(c);
            Capability addedCapability = this.addCapability0(clone);
            mapping.put(c, addedCapability);
        }
        return mapping;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public void addContentCapability(URI uri, String sha256, long length, String mime) {
        assert (uri != null);
        assert (sha256 != null && sha256.length() == 64);
        assert (length >= 0L);
        CapabilityBuilder c = new CapabilityBuilder("osgi.content");
        c.addAttribute("osgi.content", sha256);
        c.addAttribute("url", uri.toString());
        c.addAttribute("size", length);
        c.addAttribute("mime", mime != null ? mime : "application/vnd.osgi.bundle");
        this.addCapability(c);
    }

    void addContentCapability(URI uri, DeferredValue<String> sha256, long length, String mime) {
        assert (uri != null);
        assert (sha256 != null);
        assert (length >= 0L);
        CapabilityBuilder c = new CapabilityBuilder("osgi.content");
        c.addAttribute("osgi.content", sha256);
        c.addAttribute("url", uri.toString());
        c.addAttribute("size", length);
        c.addAttribute("mime", mime != null ? mime : "application/vnd.osgi.bundle");
        this.addCapability(c);
    }

    public boolean addFile(File file, URI uri) throws Exception {
        if (uri == null) {
            uri = file.toURI();
        }
        boolean hasIdentity = false;
        org.osgi.resource.Resource fileResource = FileResourceCache.getInstance().getResource(file, uri);
        if (fileResource != null) {
            this.addResource(fileResource);
            hasIdentity = !fileResource.getCapabilities("osgi.identity").isEmpty();
        }
        return hasIdentity;
    }

    public void addHashes(File file) throws IOException {
        Set<Capability> packageCapabilities = this.capabilities.remove("osgi.wiring.package");
        if (packageCapabilities == null || packageCapabilities.isEmpty()) {
            return;
        }
        if (packageCapabilities.stream().anyMatch(cap -> cap.getAttributes().containsKey("bnd.hashes"))) {
            this.capabilities.put("osgi.wiring.package", packageCapabilities);
            return;
        }
        JarIndex index = new JarIndex(file);
        for (Capability cap2 : packageCapabilities) {
            CapReqBuilder builder = CapReqBuilder.clone(cap2);
            this.addHashes(index, cap2, builder);
            this.addCapability(builder);
        }
    }

    private void addHashes(Map<String, List<Long>> hashes) throws IOException {
        Set<Capability> packageCapabilities = this.capabilities.remove("osgi.wiring.package");
        if (packageCapabilities == null || packageCapabilities.isEmpty()) {
            return;
        }
        if (packageCapabilities.stream().anyMatch(cap -> cap.getAttributes().containsKey("bnd.hashes"))) {
            this.capabilities.put("osgi.wiring.package", packageCapabilities);
            return;
        }
        for (Capability cap2 : packageCapabilities) {
            CapReqBuilder builder = CapReqBuilder.clone(cap2);
            String pkg = (String)cap2.getAttributes().get(cap2.getNamespace());
            List<Long> ourHashes = hashes.get(pkg);
            if (ourHashes != null) {
                builder.addAttribute("bnd.hashes", ourHashes);
            }
            this.addCapability(builder);
        }
    }

    private void addHashes(Hierarchy index, Capability cap, CapReqBuilder builder) {
        FolderNode resources = Optional.ofNullable((String)cap.getAttributes().get("osgi.wiring.package")).map(Descriptors::fqnToBinary).flatMap(index::findFolder).orElse(null);
        if (resources == null) {
            return;
        }
        List hashes = resources.stream().map(NamedNode::name).filter(Descriptors::isBinaryClass).map(Descriptors::binaryToSimple).distinct().filter(simple -> !Verifier.isNumber(simple)).map(simple -> ClassIndexerAnalyzer.hash(simple)).collect(Collectors.toList());
        if (hashes.isEmpty()) {
            return;
        }
        builder.addAttribute("bnd.hashes", hashes);
    }

    public ResourceBuilder safeResourceBuilder() {
        return new SafeResourceBuilder();
    }

    public void addWorkspaceNamespace(String name) {
        CapabilityBuilder cap = new CapabilityBuilder("bnd.workspace.project");
        cap.addAttribute("bnd.workspace.project", name);
        this.addCapability(cap);
    }

    public String toString() {
        return "ResourceBuilder [caps=" + this.capabilities + ", reqs=" + this.requirements + ']';
    }

    public static Supplier<org.osgi.resource.Resource> memoize(Jar jar, URI uri, String projectName) throws Exception {
        assert (jar != null) : "jar is mandatory";
        assert (jar.getSHA256().isPresent()) : "jar must have sha256";
        assert (uri != null) : "uri must be set";
        Manifest m = jar.getManifest();
        if (m == null) {
            return null;
        }
        Domain d = Domain.domain(m);
        byte[] digest = jar.getSHA256().get();
        int length = jar.getLength();
        HashMap hashes = new HashMap();
        Parameters exports = d.getExportPackage();
        for (String pkg : exports.keyList()) {
            List theseHashes;
            Map<String, Resource> dirEntries = jar.getDirectory(Descriptors.fqnToBinary(pkg));
            if (dirEntries == null || (theseHashes = dirEntries.keySet().stream().filter(Descriptors::isBinaryClass).map(Descriptors::binaryToSimple).distinct().filter(simple -> !Verifier.isNumber(simple)).map(simple -> ClassIndexerAnalyzer.hash(simple)).collect(Collectors.toList())).isEmpty()) continue;
            hashes.put(pkg, theseHashes);
        }
        jar = null;
        return () -> {
            try {
                ResourceBuilder rb = new ResourceBuilder();
                boolean hasIdentity = rb.addManifest(d);
                if (hasIdentity) {
                    String mime = hasIdentity ? "application/vnd.osgi.bundle" : "application/java-archive";
                    String sha256 = Hex.toHexString(digest);
                    rb.addContentCapability(uri, sha256, (long)length, mime);
                    rb.addHashes(hashes);
                }
                if (projectName != null) {
                    rb.addWorkspaceNamespace(projectName);
                }
                return rb.build();
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    private static class NamespaceComparator
    implements Comparator<String> {
        private NamespaceComparator() {
        }

        @Override
        public int compare(String left, String right) {
            return NamespaceComparator.map(left).compareTo(NamespaceComparator.map(right));
        }

        private static String map(String namespace) {
            switch (namespace) {
                case "osgi.identity": {
                    return "1";
                }
                case "osgi.wiring.package": {
                    return "2";
                }
                case "osgi.wiring.bundle": {
                    return "3";
                }
                case "osgi.wiring.host": {
                    return "4";
                }
            }
            return namespace;
        }
    }

    private class SafeResourceBuilder
    extends ResourceBuilder {
        private SafeResourceBuilder() {
        }

        @Override
        public org.osgi.resource.Resource build() {
            return null;
        }

        @Override
        public ResourceBuilder addResource(org.osgi.resource.Resource source) {
            return ResourceBuilder.this.addResource(source);
        }

        @Override
        public ResourceBuilder addCapability(Capability capability) {
            return ResourceBuilder.this.addCapability(capability);
        }

        @Override
        public ResourceBuilder addCapability(CapReqBuilder builder) {
            return ResourceBuilder.this.addCapability(builder);
        }

        public int hashCode() {
            return ResourceBuilder.this.hashCode();
        }

        @Override
        public ResourceBuilder addRequirement(Requirement requirement) {
            return ResourceBuilder.this.addRequirement(requirement);
        }

        @Override
        public ResourceBuilder addRequirement(CapReqBuilder builder) {
            return ResourceBuilder.this.addRequirement(builder);
        }

        @Override
        public List<Capability> getCapabilities() {
            return Collections.unmodifiableList(ResourceBuilder.this.getCapabilities());
        }

        @Override
        public List<Requirement> getRequirements() {
            return Collections.unmodifiableList(ResourceBuilder.this.getRequirements());
        }

        @Override
        public boolean addManifest(Domain manifest) {
            return false;
        }

        public boolean equals(Object obj) {
            return ResourceBuilder.this.equals(obj);
        }

        @Override
        public void addExportServices(Parameters exportServices) {
            ResourceBuilder.this.addExportServices(exportServices);
        }

        @Override
        public void addImportServices(Parameters importServices) {
            ResourceBuilder.this.addImportServices(importServices);
        }

        @Override
        public RequirementBuilder getNativeCode(String header) {
            return ResourceBuilder.this.getNativeCode(header);
        }

        @Override
        public String toString() {
            return ResourceBuilder.this.toString();
        }

        @Override
        public void addRequireBundles(Parameters requireBundle) {
            ResourceBuilder.this.addRequireBundles(requireBundle);
        }

        @Override
        public void addRequireBundle(String bsn, VersionRange range) {
            ResourceBuilder.this.addRequireBundle(bsn, range);
        }

        @Override
        public void addRequireBundle(String bsn, Attrs attrs) {
            ResourceBuilder.this.addRequireBundle(bsn, attrs);
        }

        @Override
        public void addFragmentHost(String bsn, Attrs attrs) {
            ResourceBuilder.this.addFragmentHost(bsn, attrs);
        }

        @Override
        public void addRequireCapabilities(Parameters required) {
            ResourceBuilder.this.addRequireCapabilities(required);
        }

        @Override
        public void addRequireCapability(String namespace, String name, Attrs attrs) {
            ResourceBuilder.this.addRequireCapability(namespace, name, attrs);
        }

        @Override
        public List<Capability> addProvideCapabilities(Parameters capabilities) {
            return ResourceBuilder.this.addProvideCapabilities(capabilities);
        }

        @Override
        public List<Capability> addProvideCapabilities(String clauses) {
            return ResourceBuilder.this.addProvideCapabilities(clauses);
        }

        @Override
        public Capability addProvideCapability(String namespace, Attrs attrs) {
            return ResourceBuilder.this.addProvideCapability(namespace, attrs);
        }

        @Override
        public void addExportPackages(Parameters exports, String bundle_symbolic_name, Version bundle_version) {
            ResourceBuilder.this.addExportPackages(exports, bundle_symbolic_name, bundle_version);
        }

        @Override
        public void addExportPackages(Parameters exports) {
            ResourceBuilder.this.addExportPackages(exports);
        }

        @Override
        public void addEE(EE ee) {
            ResourceBuilder.this.addEE(ee);
        }

        @Override
        public void addExportPackage(String name, Attrs attrs, String bundle_symbolic_name, Version bundle_version) {
            ResourceBuilder.this.addExportPackage(name, attrs, bundle_symbolic_name, bundle_version);
        }

        @Override
        public void addExportPackage(String name, Attrs attrs) {
            ResourceBuilder.this.addExportPackage(name, attrs);
        }

        @Override
        public void addImportPackages(Parameters imports) {
            ResourceBuilder.this.addImportPackages(imports);
        }

        @Override
        public Requirement addImportPackage(String name, Attrs attrs) {
            return ResourceBuilder.this.addImportPackage(name, attrs);
        }

        @Override
        public void addExecutionEnvironment(EE ee) {
            ResourceBuilder.this.addExecutionEnvironment(ee);
        }

        @Override
        public void addAllExecutionEnvironments(EE ee) {
            ResourceBuilder.this.addAllExecutionEnvironments(ee);
        }

        @Override
        public void copyCapabilities(Set<String> ignoreNamespaces, org.osgi.resource.Resource r) {
            ResourceBuilder.this.copyCapabilities(ignoreNamespaces, r);
        }

        @Override
        public void addCapabilities(List<Capability> capabilities) {
            ResourceBuilder.this.addCapabilities(capabilities);
        }

        @Override
        public void addRequirement(List<Requirement> requirements) {
            ResourceBuilder.this.addRequirement(requirements);
        }

        @Override
        public void addRequirements(List<Requirement> requires) {
            ResourceBuilder.this.addRequirements(requires);
        }

        @Override
        public List<Capability> findCapabilities(String ns, String filter) {
            return ResourceBuilder.this.findCapabilities(ns, filter);
        }

        @Override
        public Map<Capability, Capability> from(org.osgi.resource.Resource bundle) {
            return ResourceBuilder.this.from(bundle);
        }

        @Override
        public Reporter getReporter() {
            return ResourceBuilder.this.getReporter();
        }

        @Override
        public void addContentCapability(URI uri, String sha256, long length, String mime) {
            ResourceBuilder.this.addContentCapability(uri, sha256, length, mime);
        }

        @Override
        public boolean addFile(File file, URI uri) throws Exception {
            return false;
        }
    }
}

