/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.exceptions.SupplierWithException;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.resource.DeferredComparableValue;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.libg.cryptography.SHA256;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(FileResourceCache.class);
    private static final long EXPIRED_DURATION_NANOS = TimeUnit.NANOSECONDS.convert(30L, TimeUnit.MINUTES);
    private static final FileResourceCache INSTANCE = new FileResourceCache();
    private final Map<CacheKey, Resource> cache = new ConcurrentHashMap<CacheKey, Resource>();
    private long time = System.nanoTime();

    private FileResourceCache() {
    }

    static FileResourceCache getInstance() {
        return INSTANCE;
    }

    Resource getResource(File file, URI uri) {
        if (!file.isFile()) {
            return null;
        }
        long now = System.nanoTime();
        if (now - this.time > EXPIRED_DURATION_NANOS) {
            this.time = now;
            this.cache.keySet().removeIf(key -> now - key.time > EXPIRED_DURATION_NANOS);
        }
        CacheKey cacheKey = new CacheKey(file);
        Resource resource = this.cache.computeIfAbsent(cacheKey, key -> {
            logger.debug("parsing {}", (Object)file);
            ResourceBuilder rb = new ResourceBuilder();
            try {
                Domain manifest = Domain.domain(file);
                boolean hasIdentity = false;
                if (manifest != null) {
                    hasIdentity = rb.addManifest(manifest);
                }
                String mime = hasIdentity ? "application/vnd.osgi.bundle" : "application/java-archive";
                DeferredComparableValue<Object> sha256 = new DeferredComparableValue<Object>(String.class, SupplierWithException.asSupplierOrElse(() -> SHA256.digest(file).asHex(), null), key.hashCode());
                rb.addContentCapability(uri, sha256, file.length(), mime);
                if (hasIdentity) {
                    rb.addHashes(file);
                }
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
            return rb.build();
        });
        return resource;
    }

    static final class CacheKey {
        private final Object fileKey;
        private final long lastModifiedTime;
        private final long size;
        final long time;

        CacheKey(File file) {
            this(file.toPath());
        }

        CacheKey(Path path) {
            BasicFileAttributes attributes;
            try {
                attributes = Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            }
            catch (IOException e) {
                throw Exceptions.duck(e);
            }
            if (!attributes.isRegularFile()) {
                throw new IllegalArgumentException("File must be a regular file: " + path);
            }
            Object fileKey = attributes.fileKey();
            this.fileKey = fileKey != null ? fileKey : path.toAbsolutePath();
            this.lastModifiedTime = attributes.lastModifiedTime().toMillis();
            this.size = attributes.size();
            this.time = System.nanoTime();
        }

        public int hashCode() {
            return (Objects.hashCode(this.fileKey) * 31 + Long.hashCode(this.lastModifiedTime)) * 31 + Long.hashCode(this.size);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return Objects.equals(this.fileKey, other.fileKey) && this.lastModifiedTime == other.lastModifiedTime && this.size == other.size;
        }

        public String toString() {
            return Objects.toString(this.fileKey);
        }
    }
}

