/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.agent;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.MBeanServiceTracker;
import org.apache.aries.jmx.agent.JMXAgent;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.apache.aries.jmx.cm.ConfigurationAdminMBeanHandler;
import org.apache.aries.jmx.framework.BundleStateMBeanHandler;
import org.apache.aries.jmx.framework.FrameworkMBeanHandler;
import org.apache.aries.jmx.framework.PackageStateMBeanHandler;
import org.apache.aries.jmx.framework.ServiceStateMBeanHandler;
import org.apache.aries.jmx.framework.StateConfig;
import org.apache.aries.jmx.framework.wiring.BundleWiringStateMBeanHandler;
import org.apache.aries.jmx.permissionadmin.PermissionAdminMBeanHandler;
import org.apache.aries.jmx.provisioning.ProvisioningServiceMBeanHandler;
import org.apache.aries.jmx.useradmin.UserAdminMBeanHandler;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class JMXAgentImpl
implements JMXAgent {
    private ServiceTracker mbeanServiceTracker;
    private Map<MBeanServer, Boolean> mbeanServers;
    private Map<MBeanHandler, Boolean> mbeansHandlers;
    private StateConfig stateConfig;
    private BundleContext context;
    private Logger logger;

    public JMXAgentImpl(BundleContext context, StateConfig stateConfig, Logger logger) {
        this.context = context;
        this.stateConfig = stateConfig;
        this.logger = logger;
        this.mbeanServers = new IdentityHashMap<MBeanServer, Boolean>();
        this.mbeansHandlers = new IdentityHashMap<MBeanHandler, Boolean>();
    }

    @Override
    public synchronized void start() {
        this.logger.log(3, "Starting JMX OSGi agent");
        JMXAgentContext agentContext = new JMXAgentContext(this.context, this, this.logger);
        FrameworkMBeanHandler frameworkHandler = new FrameworkMBeanHandler(agentContext);
        this.mbeansHandlers.put(frameworkHandler, Boolean.FALSE);
        frameworkHandler.open();
        BundleStateMBeanHandler bundleStateHandler = new BundleStateMBeanHandler(agentContext, this.stateConfig);
        this.mbeansHandlers.put(bundleStateHandler, Boolean.FALSE);
        bundleStateHandler.open();
        BundleWiringStateMBeanHandler revisionsStateHandler = new BundleWiringStateMBeanHandler(agentContext);
        this.mbeansHandlers.put(revisionsStateHandler, Boolean.FALSE);
        revisionsStateHandler.open();
        ServiceStateMBeanHandler serviceStateHandler = new ServiceStateMBeanHandler(agentContext, this.stateConfig);
        this.mbeansHandlers.put(serviceStateHandler, Boolean.FALSE);
        serviceStateHandler.open();
        PackageStateMBeanHandler packageStateHandler = new PackageStateMBeanHandler(agentContext);
        this.mbeansHandlers.put(packageStateHandler, Boolean.FALSE);
        packageStateHandler.open();
        PermissionAdminMBeanHandler permissionAdminHandler = new PermissionAdminMBeanHandler(agentContext);
        this.mbeansHandlers.put(permissionAdminHandler, Boolean.FALSE);
        permissionAdminHandler.open();
        UserAdminMBeanHandler userAdminHandler = new UserAdminMBeanHandler(agentContext);
        this.mbeansHandlers.put(userAdminHandler, Boolean.FALSE);
        userAdminHandler.open();
        ConfigurationAdminMBeanHandler configAdminHandler = new ConfigurationAdminMBeanHandler(agentContext);
        this.mbeansHandlers.put(configAdminHandler, Boolean.FALSE);
        configAdminHandler.open();
        ProvisioningServiceMBeanHandler provServiceHandler = new ProvisioningServiceMBeanHandler(agentContext);
        this.mbeansHandlers.put(provServiceHandler, Boolean.FALSE);
        provServiceHandler.open();
        this.mbeanServiceTracker = new MBeanServiceTracker(agentContext);
        this.mbeanServiceTracker.open();
    }

    @Override
    public synchronized void registerMBeans(MBeanServer server) {
        for (MBeanHandler mbeanHandler : this.mbeansHandlers.keySet()) {
            if (this.mbeansHandlers.get(mbeanHandler) != Boolean.TRUE) continue;
            String name = mbeanHandler.getName();
            StandardMBean mbean = mbeanHandler.getMbean();
            if (mbean == null) continue;
            try {
                this.logger.log(3, "Registering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                server.registerMBean(mbean, new ObjectName(name));
            }
            catch (InstanceAlreadyExistsException e) {
                this.logger.log(1, "MBean is already registered", e);
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (NotCompliantMBeanException e) {
                this.logger.log(1, "MBean is not compliant MBean", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname", e);
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null", e);
            }
        }
        this.mbeanServers.put(server, Boolean.TRUE);
    }

    @Override
    public synchronized void unregisterMBeans(MBeanServer server) {
        for (MBeanHandler mBeanHandler : this.mbeansHandlers.keySet()) {
            if (this.mbeansHandlers.get(mBeanHandler) != Boolean.TRUE) continue;
            try {
                String name = mBeanHandler.getName();
                StandardMBean mbean = mBeanHandler.getMbean();
                if (mbean == null) continue;
                this.logger.log(3, "Unregistering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                server.unregisterMBean(new ObjectName(name));
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't unregister MBean", e);
            }
            catch (InstanceNotFoundException e) {
                this.logger.log(1, "MBean doesn't exist in the repository", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to unregister with no valid objectname", e);
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null ", e);
            }
            catch (Exception e) {
                this.logger.log(1, "Cannot unregister MBean: " + mBeanHandler, e);
            }
        }
        this.mbeanServers.remove(server);
    }

    @Override
    public synchronized void registerMBean(MBeanHandler mBeanHandler) {
        for (MBeanServer server : this.mbeanServers.keySet()) {
            String name = mBeanHandler.getName();
            StandardMBean mbean = mBeanHandler.getMbean();
            try {
                this.logger.log(3, "Registering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                server.registerMBean(mbean, new ObjectName(name));
            }
            catch (InstanceAlreadyExistsException e) {
                this.logger.log(1, "MBean is already registered", e);
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (NotCompliantMBeanException e) {
                this.logger.log(1, "MBean is not compliant MBean, Stopping registration", e);
                return;
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname, Stopping registration", e);
                return;
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null, Stopping registration", e);
                return;
            }
        }
        this.mbeansHandlers.put(mBeanHandler, Boolean.TRUE);
    }

    @Override
    public synchronized void unregisterMBean(MBeanHandler mBeanHandler) {
        for (MBeanServer server : this.mbeanServers.keySet()) {
            String name = mBeanHandler.getName();
            try {
                this.logger.log(3, "Unregistering mbean  to MBeanServer " + server + " with name " + name);
                server.unregisterMBean(new ObjectName(name));
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (InstanceNotFoundException e) {
                this.logger.log(1, "MBean doesn't exist in the repository", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname, Stopping registration", e);
                return;
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null, Stopping registration", e);
                return;
            }
        }
        this.mbeansHandlers.put(mBeanHandler, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.logger.log(3, "Stopping JMX OSGi agent");
        JMXAgentImpl jMXAgentImpl = this;
        synchronized (jMXAgentImpl) {
            this.mbeanServiceTracker.close();
            for (MBeanHandler mBeanHandler : this.mbeansHandlers.keySet()) {
                mBeanHandler.close();
            }
        }
    }
}

