/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.server.util.json.JsonValue;

public class JsonObject
implements JsonValue {
    protected final ObjectNode node;

    JsonObject(ObjectNode node) {
        this.node = node;
    }

    @Override
    public JsonNode node() {
        return this.node;
    }

    public JsonValue apply(String name) throws JsonMappingException {
        return this.get(name).orElseThrow(() -> new JsonMappingException(null, "No such field exists: `" + name + "`"));
    }

    public Optional<JsonValue> get(String name) {
        return Optional.ofNullable(this.node().get(name)).map(JsonValue::apply);
    }

    public Iterator<Map.Entry<String, JsonValue>> iterator() {
        Iterator iterator = this.node.fields();
        Stream<Map.Entry> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        Stream<Map.Entry> results = stream.map(entry -> new AbstractMap.SimpleEntry<String, JsonValue>((String)entry.getKey(), JsonValue.apply((JsonNode)entry.getValue())));
        return results.collect(Collectors.toList()).iterator();
    }

    public int hashCode() {
        return this.node().hashCode();
    }

    public boolean equals(Object a) {
        if (a instanceof JsonObject) {
            return this.node().equals((Object)((JsonObject)a).node());
        }
        return false;
    }

    public String toString() {
        return this.node().toString();
    }
}

