/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.state.HostInfo;

public class StreamsMetadataImpl
implements StreamsMetadata {
    private final HostInfo hostInfo;
    private final Set<String> stateStoreNames;
    private final Set<TopicPartition> topicPartitions;
    private final Set<String> standbyStateStoreNames;
    private final Set<TopicPartition> standbyTopicPartitions;
    private final String topologyName;

    public StreamsMetadataImpl(HostInfo hostInfo, Set<String> stateStoreNames, Set<TopicPartition> topicPartitions, Set<String> standbyStoreNames, Set<TopicPartition> standbyTopicPartitions) {
        this(hostInfo, stateStoreNames, topicPartitions, standbyStoreNames, standbyTopicPartitions, null);
    }

    public StreamsMetadataImpl(HostInfo hostInfo, Set<String> stateStoreNames, Set<TopicPartition> topicPartitions, Set<String> standbyStoreNames, Set<TopicPartition> standbyTopicPartitions, String topologyName) {
        this.hostInfo = hostInfo;
        this.stateStoreNames = Collections.unmodifiableSet(stateStoreNames);
        this.topicPartitions = Collections.unmodifiableSet(topicPartitions);
        this.standbyTopicPartitions = Collections.unmodifiableSet(standbyTopicPartitions);
        this.standbyStateStoreNames = Collections.unmodifiableSet(standbyStoreNames);
        this.topologyName = topologyName;
    }

    @Override
    public HostInfo hostInfo() {
        return this.hostInfo;
    }

    @Override
    public Set<String> stateStoreNames() {
        return this.stateStoreNames;
    }

    @Override
    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Override
    public Set<TopicPartition> standbyTopicPartitions() {
        return this.standbyTopicPartitions;
    }

    @Override
    public Set<String> standbyStateStoreNames() {
        return this.standbyStateStoreNames;
    }

    @Override
    public String host() {
        return this.hostInfo.host();
    }

    @Override
    public int port() {
        return this.hostInfo.port();
    }

    public String topologyName() {
        return this.topologyName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamsMetadataImpl that = (StreamsMetadataImpl)o;
        return Objects.equals(this.hostInfo, that.hostInfo) && Objects.equals(this.stateStoreNames, that.stateStoreNames) && Objects.equals(this.topicPartitions, that.topicPartitions) && Objects.equals(this.standbyStateStoreNames, that.standbyStateStoreNames) && Objects.equals(this.standbyTopicPartitions, that.standbyTopicPartitions) && Objects.equals(this.topologyName, that.topologyName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostInfo, this.stateStoreNames, this.topicPartitions, this.standbyStateStoreNames, this.standbyTopicPartitions);
    }

    public String toString() {
        String str = "StreamsMetadata {hostInfo=" + this.hostInfo + ", stateStoreNames=" + this.stateStoreNames + ", topicPartitions=" + this.topicPartitions + ", standbyStateStoreNames=" + this.standbyStateStoreNames + ", standbyTopicPartitions=" + this.standbyTopicPartitions;
        if (this.topologyName == null) {
            return str + '}';
        }
        return str + ", topologyName=" + this.topologyName + '}';
    }
}

