/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Optional;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.JoinWindowsInternal;
import org.apache.kafka.streams.kstream.internals.KStreamImplJoin;
import org.apache.kafka.streams.kstream.internals.KStreamKStreamJoin;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.state.internals.LeftOrRightValue;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSide;

class KStreamKStreamJoinLeftSide<K, VLeft, VRight, VOut>
extends KStreamKStreamJoin<K, VLeft, VRight, VOut, VLeft, VRight> {
    KStreamKStreamJoinLeftSide(String otherWindowName, JoinWindowsInternal windows, ValueJoinerWithKey<? super K, ? super VLeft, ? super VRight, ? extends VOut> joiner, boolean outer, Optional<String> outerJoinWindowName, KStreamImplJoin.TimeTrackerSupplier sharedTimeTrackerSupplier) {
        super(otherWindowName, windows, joiner, outer, outerJoinWindowName, windows.beforeMs, windows.afterMs, sharedTimeTrackerSupplier);
    }

    @Override
    public Processor<K, VLeft, K, VOut> get() {
        return new KStreamKStreamJoinLeftProcessor();
    }

    private class KStreamKStreamJoinLeftProcessor
    extends KStreamKStreamJoin.KStreamKStreamJoinProcessor {
        private KStreamKStreamJoinLeftProcessor() {
            super(KStreamKStreamJoinLeftSide.this);
        }

        @Override
        public TimestampedKeyAndJoinSide<K> makeThisKey(K key, long timestamp) {
            return TimestampedKeyAndJoinSide.makeLeft(key, timestamp);
        }

        public LeftOrRightValue<VLeft, VRight> makeThisValue(VLeft thisValue) {
            return LeftOrRightValue.makeLeftValue(thisValue);
        }

        @Override
        public TimestampedKeyAndJoinSide<K> makeOtherKey(K key, long timestamp) {
            return TimestampedKeyAndJoinSide.makeRight(key, timestamp);
        }

        public VLeft getThisValue(LeftOrRightValue<? extends VLeft, ? extends VRight> leftOrRightValue) {
            return leftOrRightValue.getLeftValue();
        }

        public VRight getOtherValue(LeftOrRightValue<? extends VLeft, ? extends VRight> leftOrRightValue) {
            return leftOrRightValue.getRightValue();
        }
    }
}

