/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.UUID;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.measure.Units;
import org.apache.sis.util.Locales;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.xml.LegacyCodes;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.XPointer;

public class ValueConverter {
    public static final ValueConverter DEFAULT = new ValueConverter();

    protected ValueConverter() {
    }

    protected <T> boolean exceptionOccured(MarshalContext context2, T value, Class<T> sourceType, Class<?> targetType, Exception exception) {
        return false;
    }

    public String toLanguageCode(MarshalContext context2, Locale value) throws MissingResourceException {
        if (value != null) {
            String code;
            try {
                code = value.getISO3Language();
            }
            catch (MissingResourceException e2) {
                if (!this.exceptionOccured(context2, value, Locale.class, String.class, e2)) {
                    throw e2;
                }
                code = value.getLanguage();
            }
            if (!code.isEmpty()) {
                return code;
            }
        }
        return null;
    }

    public String toCountryCode(MarshalContext context2, Locale value) throws MissingResourceException {
        String code;
        if (value != null && !(code = value.getCountry()).isEmpty()) {
            return code;
        }
        return null;
    }

    public String toCharsetCode(MarshalContext context2, Charset value) {
        if (value != null) {
            return LegacyCodes.fromIANA(value.name());
        }
        return null;
    }

    public Locale toLocale(MarshalContext context2, String value) throws IllformedLocaleException {
        block3: {
            if ((value = Strings.trimOrNull(value)) != null) {
                try {
                    return Locales.parse(value);
                }
                catch (IllformedLocaleException e2) {
                    if (this.exceptionOccured(context2, value, String.class, Locale.class, e2)) break block3;
                    throw e2;
                }
            }
        }
        return null;
    }

    public Charset toCharset(MarshalContext context2, String value) throws IllegalCharsetNameException {
        block3: {
            if ((value = Strings.trimOrNull(value)) != null) {
                value = LegacyCodes.toIANA(value);
                try {
                    return Charset.forName(value);
                }
                catch (IllegalCharsetNameException e2) {
                    if (this.exceptionOccured(context2, value, String.class, Charset.class, e2)) break block3;
                    throw e2;
                }
            }
        }
        return null;
    }

    public Unit<?> toUnit(MarshalContext context2, String value) throws IllegalArgumentException {
        block4: {
            if ((value = Strings.trimOrNull(value)) != null) {
                try {
                    String anchor;
                    int endOfURI = XPointer.endOfURI(value, 0);
                    if (endOfURI > 0 && (anchor = XPointer.UOM.reference(value.substring(0, endOfURI))) != null) {
                        value = anchor;
                    }
                    return Units.valueOf(value);
                }
                catch (MeasurementParseException e2) {
                    if (this.exceptionOccured(context2, value, String.class, Unit.class, e2)) break block4;
                    throw e2;
                }
            }
        }
        return null;
    }

    public UUID toUUID(MarshalContext context2, String value) throws IllegalArgumentException {
        block3: {
            if ((value = Strings.trimOrNull(value)) != null) {
                try {
                    return UUID.fromString(value);
                }
                catch (IllegalArgumentException e2) {
                    if (this.exceptionOccured(context2, value, String.class, UUID.class, e2)) break block3;
                    throw e2;
                }
            }
        }
        return null;
    }

    public URI toURI(MarshalContext context2, String value) throws URISyntaxException {
        block3: {
            if ((value = Strings.trimOrNull(value)) != null) {
                try {
                    return new URI(value);
                }
                catch (URISyntaxException e2) {
                    if (this.exceptionOccured(context2, value, String.class, URI.class, e2)) break block3;
                    throw e2;
                }
            }
        }
        return null;
    }

    public URI toURI(MarshalContext context2, URL value) throws URISyntaxException {
        block3: {
            if (value != null) {
                try {
                    return value.toURI();
                }
                catch (URISyntaxException e2) {
                    if (this.exceptionOccured(context2, value, URL.class, URI.class, e2)) break block3;
                    throw e2;
                }
            }
        }
        return null;
    }

    public URL toURL(MarshalContext context2, URI value) throws MalformedURLException {
        block3: {
            if (value != null) {
                try {
                    return value.toURL();
                }
                catch (IllegalArgumentException | MalformedURLException e2) {
                    if (this.exceptionOccured(context2, value, URI.class, URL.class, e2)) break block3;
                    throw e2;
                }
            }
        }
        return null;
    }

    public NilReason toNilReason(MarshalContext context2, String value) throws URISyntaxException {
        block3: {
            if ((value = Strings.trimOrNull(value)) != null) {
                try {
                    return NilReason.valueOf(value);
                }
                catch (URISyntaxException e2) {
                    if (this.exceptionOccured(context2, value, String.class, URI.class, e2)) break block3;
                    throw e2;
                }
            }
        }
        return null;
    }
}

